<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <title>پروفایل</title>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">کاربر</li>
                <li class="breadcrumb-item active">پروفایل</li>
            </ol>
            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <!-- Row start -->
            <div class="row gutters elan">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="alert-notify info">
                        <div class="alert-notify-body">
                            <span class="type"></span>
                            <div class="alert-notify-title"></div>
                            <div class=" alert-notify-text
                                    ">
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="row gutters">
                <div class="col-xl-3 col-lg-3 col-md-12 col-sm-12 col-12">
                    <div class="card h-100">
                        <div class="card-body">
                            <div class="account-settings">
                                <div class="user-profile">
                                    <div class="user-avatar">
                                        <img src="<?= base_url('Assets/userImg/') . $this->user_img; ?>"
                                             alt="Wafi Admin"/>
                                    </div>
                                    <h5 class="user-name"><?= $this->user_name; ?></h5>
                                    <h6 class="user-email">اخرین ورود شما : <?= $this->user_lastLogin; ?></h6>
                                </div>
                                <div class="setting-links">
                                    <a href="chat.html">
                                        <i class="icon-chat"></i>
                                        پیام ها
                                    </a>
                                    <a href="tasks.html">
                                        <i class="icon-date_range"></i>
                                        کارها
                                    </a>
                                    <a href="documents.html">
                                        <i class="icon-file-text"></i>
                                        اسناد
                                    </a>
                                    <a href="faq.html">
                                        <i class="icon-info"></i>
                                        سوالات متداول
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-lg-9 col-md-12 col-sm-12 col-12">
                    <form id="editInfo" method="post">
                        <div class="card h-100">
                            <div class="card-header">
                                <div class="card-title">بروز رسانی پروفایل</div>
                            </div>
                            <div class="card-body">
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label for="firstName">نام </label>
                                            <input type="text" class="form-control" name="firstName" id="firstName"
                                                   placeholder="نام خود را وارد کنید ">
                                        </div>
                                        <div class="form-group">
                                            <label for="lastName">نام خانوادگی</label>
                                            <input type="text" class="form-control" name="lastName" id="lastName"
                                                   placeholder="نام خانوادگی خود را وارد کنید">
                                        </div>
                                        <div class="form-group">
                                            <label for="Mobile">شماره موبایل</label>
                                            <input type="text" class="form-control" name="Mobile" id="Mobile"
                                                   placeholder="شماره موبایل خود را وارد کنید">
                                        </div>
                                        <div class="form-group">
                                            <div class="text-right">
                                                <button type="submit" id="editInfo"
                                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                                    بروزرسانی
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-xl-3 col-lg-9 col-md-12 col-sm-12 col-12">
                    <form id="editPass" method="post">
                        <div class="card h-100">
                            <div class="card-header">
                                <div class="card-title">بروز رسانی تنظیمات ورود</div>
                            </div>
                            <div class="card-body">
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label for="Pass">گذرواژه فعلی </label>
                                            <input type="password" class="form-control" name="Pass" id="Pass"
                                                   placeholder="گذرواژه فعلی خود را وارد کنید ">
                                        </div>
                                        <div class="form-group">
                                            <label for="newPass">گذرواژه جدید <i class="icon-eye" id="newPassView"></i>
                                            </label>
                                            <input type="password" class="form-control" name="newPass" id="newPass"
                                                   placeholder="گذرواژه جدید خود را وارد کنید">
                                            <small id="PassCheck" class="text-muted">
                                            </small>

                                        </div>
                                        <div class="form-group">
                                            <label for="newPassRepeat">تکرار گذرواژه جدید <i class="icon-eye"
                                                                                             id="newPassRepeatView"></i>
                                            </label>
                                            <input type="password" class="form-control" name="newPassRepeat"
                                                   id="newPassRepeat"
                                                   placeholder="تکرار گذرواژه جدید خود را وارد کنید">
                                        </div>
                                        <div class="form-group">
                                            <div class="text-right">
                                                <button type="submit" id="editPassword"
                                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                                    بروزرسانی
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-xl-3 col-lg-9 col-md-12 col-sm-12 col-12">
                    <form id="editImg" method="post">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">بروز رسانی تصویر پروفایل</div>
                            </div>
                            <div class="card-body">
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-6 col-md-6 col-sm-6 col-12">
                                        <div class="form-group">
                                            <label for="userImage">تصویر پروفایل </label>
                                            <input type="file" class="form-control" name="userImage" id="userImage"
                                                   placeholder="گذرواژه فعلی خود را وارد کنید ">
                                        </div>
                                        <div class="form-group">
                                            <div class="text-right">
                                                <button type="submit" id="editImg"
                                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                                    بروزرسانی
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- Row end -->
        </div>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>send/User/index.js"></script>
</body>
</html>