<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <title> داشبورد / کاربران</title>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">داشبورد</li>
                <li class="breadcrumb-item active">کاربران</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">

            <!-- Row start -->
            <div class="row gutters elan">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="alert-notify info">
                        <div class="alert-notify-body">
                            <span class="type"></span>
                            <div class="alert-notify-title"></div>
                            <div class=" alert-notify-text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row gutters">

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="text-right mb-3">
                        <!-- Button trigger modal -->
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addNewContact">
                            افزودن انباردار جدید
                        </button>

                        <!-- Modal -->
                        <div class="modal fade" id="addNewContact" tabindex="-1" role="dialog"

                             aria-labelledby="addNewContactLabel" aria-hidden="true">

                            <div class="modal-dialog" role="document">
                                <div class="row gutters elanModal">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                        <div class="alert-notify info">
                                            <div class="alert-notify-body">
                                                <span class="type"></span>
                                                <div class="alert-notify-title"></div>
                                                <div class=" alert-notify-text">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="addNewContactLabel">انباردار جدید</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <form class="row gutters" id="CreateUser" method="post">
                                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                                <div class="upload-photo-container">
                                                    <div class="form-group m-0">
                                                        <div class="input-group">
                                                            <div class="custom-file">
                                                                <input type="file" class="custom-file-input"
                                                                       id="uploadPhoto" name="userImage">
                                                                <label class="custom-file-label" for="uploadPhoto"
                                                                       aria-describedby="uploadPhotoAddon">تصویر
                                                                    انبارار </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="form-group">
                                                    <label for="firstName">نام :</label>
                                                    <input type="text" class="form-control" name="firstName"
                                                           id="firstName">
                                                </div>
                                                <div class="form-group">
                                                    <label for="lastName">نام خانوادگی :</label>
                                                    <input type="text" class="form-control" name="lastName"
                                                           id="lastName">
                                                </div>
                                                <div class="form-group">
                                                    <label for="Mobile">شماره موبایل :</label>
                                                    <input type="text" class="form-control" name="Mobile" id="Mobile">
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="form-group">
                                                    <label for="userName">نام کاربری :</label>
                                                    <input type="text" class="form-control" name="userName"
                                                           id="userName">
                                                </div>
                                                <div class="form-group">
                                                    <label for="Password">گذرواژه : <i class="icon-eye"
                                                                                       id="PasswordView"></i></label>
                                                    <input type="password" class="form-control" name="Password"
                                                           id="Password">
                                                    <small id="PassCheck" class="text-muted">
                                                    </small>

                                                </div>
                                                <div class="form-group">
                                                    <p><code>نوع کاربری</code></p>
                                                    <select id="Access" class="form-control selectpicker" name="Access"
                                                            data-header="یک گزینه را انتخاب کنید">
                                                        <option value="">انتخاب کنید</option>
                                                        <option value="1">مدیر</option>
                                                        <option value="2">انباردار</option>
                                                    </select>
                                                </div>

                                            </div>
                                    </div>
                                    <div class="modal-footer custom">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-link danger btn-block"
                                                    data-dismiss="modal">لغو
                                            </button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit"
                                                    class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                                افزودن
                                            </button>
                                        </div>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <!-- Edit Contact Modal -->
                    <div class="modal fade" id="editContact" tabindex="-1" role="dialog"
                         aria-labelledby="editContactLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="row gutters elanModal">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="alert-notify info">
                                        <div class="alert-notify-body">
                                            <span class="type"></span>
                                            <div class="alert-notify-title"></div>
                                            <div class=" alert-notify-text">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editContactLabel">ویرایش انباردار</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form class="row gutters" id="EditUser" method="post">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="firstNameEdit">نام :</label>
                                                <input type="text" class="form-control" name="firstNameEdit"
                                                       id="firstNameEdit">
                                            </div>
                                            <div class="form-group">
                                                <label for="lastName">نام خانوادگی :</label>
                                                <input type="text" class="form-control" name="lastNameEdit"
                                                       id="lastNameEdit">
                                            </div>
                                            <div class="form-group">
                                                <label for="MobileEdit">شماره موبایل :</label>
                                                <input type="text" class="form-control" name="MobileEdit"
                                                       id="MobileEdit">
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="userNameEdit">نام کاربری :</label>
                                                <input type="text" class="form-control" name="userNameEdit"
                                                       id="userNameEdit">
                                                <input type="hidden" class="form-control" name="userNameEdit1"
                                                       id="userNameEdit1">
                                            </div>
                                            <div class="form-group">
                                                <label for="PasswordEdit">گذرواژه : <i class="icon-eye"
                                                                                       id="PasswordViewEdit"></i></label>
                                                <input type="password" class="form-control" name="PasswordEdit"
                                                       id="PasswordEdit">
                                                <small id="PassCheckEdit" class="text-muted">
                                                </small>

                                            </div>
                                            <div class="form-group">
                                                <p><code>نوع کاربری</code></p>
                                                <select id="AccessEdit" class="form-control selectpicker"
                                                        name="AccessEdit"
                                                        data-header="یک گزینه را انتخاب کنید">
                                                    <option value="1">مدیر</option>
                                                    <option value="2">انباردار</option>
                                                </select>
                                            </div>

                                        </div>
                                </div>
                                <div class="modal-footer custom">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-link danger btn-block"
                                                data-dismiss="modal">لغو
                                        </button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" id="EditUserbtn"
                                                class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                            بروزرسانی
                                        </button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                foreach ($User->result() as $user) {
                    echo '
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                            <figure class="user-card">
                                <figcaption>
                                    <a href="#" id="test" class="edit-card" data-toggle="modal" data-target="#editContact" data-action="editUser" data-id="' . $user->user_Id . '" >
                                        <i class="icon-mode_edit"></i>
                                    </a>
                                    <img src="' . base_url('Assets/userImg/') . $user->user_Img . '" alt="' . $user->user_firstName . ' ' . $user->user_lastName . '" class="profile">
                                    <h5>' . $user->user_firstName . ' ' . $user->user_lastName . '</h5>
                                    <ul class="list-group">
                                        <li class="list-group-item justify-content-start">' . $user->user_Mobile . '</li>
                                        <li class="list-group-item justify-content-start">اخرین ورود : ' . $user->user_lastLogin . '</li>
                                        <li class="list-group-item justify-content-start"> 
                                            <a href="#" id="test" data-action="deleteUser" data-id="' . $user->user_Id . '" >
                                                <i class="icon-delete"></i>
                                            </a>
                                            <a href="#" id="test" data-action="BanUser" data-ban="' . $user->user_Ban . '" data-id="' . $user->user_Id . '" >
                                            ';
                    if ($user->user_Ban == "0")
                        echo '<i class="icon-block color_green"></i>';
                    else
                        echo '<i class="icon-block color_red"></i>';
                    echo '
                                            </a>
                                        </li>
                                        </li>
                                    </ul>
                                </figcaption>
                            </figure>
                        </div>
                        ';
                }
                ?>
            </div>
            <!-- Row end -->
        </div>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>send/User/index.js"></script>
</body>
</html>