<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <title>انبار / <?= $info['2'] ?></title>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/storeroom_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">انبار</li>
                <li class="breadcrumb-item active"><?= $info['2'] ?></li>
            </ol>
            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-3 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-store_mall_directory"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Product); ?></h3>
                            <p>کالا</p>
                            <hr>
                            <a target="_blank" href="<?= base_url(uri_string() . '/product') ?>"><p class="text-center">
                                    افزودن کالا</p></a>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-verified_user"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Category); ?></h3>
                            <p>دسته</p>
                            <hr>
                            <p class="text-center">افزودن دسته</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-package"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Unit) ?></h3>
                            <p>واحد</p>
                            <hr>
                            <p class="text-center">افزودن واحد</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-contact_mail"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= $count_Importation ?></h3>
                            <p>ورودی ها</p>
                            <hr>
                            <p class="text-center">ثبت ورود کالا</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon primary">
                            <i class="icon-users"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Exportation) ?> </h3>
                            <p>خروجی ها</p>
                            <hr>
                            <p class="text-center">ثبت خروج کالا</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row ends -->
            <!-- Row starts -->
            <div class="row gutters justify-content-center">
            </div>
        </div>
        <?php $this->load->view('layout/footer'); ?>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<!-- Apex Charts --><!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>

</body>
</html>