<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <title>انبار / داشبورد</title>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>

<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">انبار</li>
                <li class="breadcrumb-item active"> داشبورد</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card h-360">
                        <div class="card-header">
                            <div class="card-title">مقایسه لحظه ای انبار ها</div>
                        </div>
                        <div class="card-body">
                            <!-- Row start -->
                            <div class="row gutters">
                                <div class="col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">
                                    <div id="compare-sales"></div>
                                    <div class="info-stats3 shade-one-a">
                                        <i class="icon-turned_in"></i>
                                        <h6><?= $StoreroomName_0 ?></h6>
                                    </div>
                                </div>
                                <div class="col-xl-2 col-lg-2 col-md-12 col-sm-12 col-12">
                                    <div class="vs"></div>
                                </div>
                                <div class="col-xl-5 col-lg-5 col-md-12 col-sm-12 col-12">
                                    <div id="compare-expenses"></div>
                                    <div class="info-stats3 shade-one-a">
                                        <i class="icon-turned_in"></i>
                                        <h6><?= $StoreroomName_1 ?></h6>
                                    </div>
                                </div>
                            </div>
                            <!-- Row end -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">اخرین محصولات افزوده شده</div>
                        </div>
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table projects-table">
                                    <thead>
                                    <tr>
                                        <th>نام محصول</th>
                                        <th>دسته / واحد</th>
                                        <th>ارزش مالی</th>
                                        <th>تعداد</th>
                                        <th>تاریخ افزودن محصول</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                    foreach ($Products as $element) {
                                        echo '
                                    <tr>
                                        <td>
                                            <div class="project-details">
                                                <div class="project-info">
                                                    <p>' . $element->product_Title . '</p>
                                                    <p>' . $element->storeroom_Title . '</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="project-details">
                                                <div class="project-info">
                                                    <p>' . $element->category_Title . ' / ' . $element->unit_Title . '</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="project-details">
                                                <div class="project-info">
                                                    <p>' . number_format($element->product_Price) . ' ریال</p>
                                                    <p>' . number_format($element->product_Price * $element->product_Amount) . ' ریال</p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="project-details">
                                                <div class="project-info">
                                                    <p>' . number_format($element->product_Amount) . ' ' . $element->unit_Title . ' </p>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="project-details">
                                                <div class="project-info">
                                                    <p>' . jdate('Y/m/d', $element->product_createDateTime) . ' </p>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>

                                            ';
                                    }
                                    ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Footer -->
            <!-- /Footer -->
        </div>
        <!-- Main container end -->
        <?php $this->load->view('layout/footer'); ?>
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/apex/apexcharts.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<?php
echo '
        <script>
        var options = {
	chart: {
		height: 180,
		type: \'line\',
		toolbar: {
			show: false,
		},
	},
	dataLabels: {
		enabled: false
	},
	stroke: {
		curve: \'smooth\',
		width: 2
	},
	series: [{
		name: \'تعداد\',
		data: [' . $count_Product_0 . ', ' . $count_Exportation_0 . ', ' . $Count_0 . ', ' . $count_Importation_0 . ']
	}],
	grid: {
		row: {
			colors: [\'#ffffff\'], // takes an array which will be repeated on columns
			opacity: 0.5,
		},
		xaxis: {
      lines: {
        show: false
      }
    },   
    yaxis: {
      lines: {
        show: false
      }
    },
	},
	xaxis: {
		categories: [\'محصول\', \'فاکتورهای صادره\', \'ارزش رقمی\', \'فاکتورهای وارده\'],
		// labels: {
	 //    show: false
	 //  }
	},
	colors: [\'#1a8e5f\', \'#262b31\', \'#434950\', \'#63686f\', \'#868a90\'],
	markers: {
		size: 3,
		opacity: 0.2,
		colors: ["#1a6e5f"],
		strokeColor: "#ffffff",
		strokeWidth: 2,
		hover: {
			size: 7,
		}
	},
	tooltip: {
		y: {
			formatter: function(val) {
				return    val
			}
		}
	},
}

var chart = new ApexCharts(
	document.querySelector("#compare-sales"),
	options
);

chart.render();
var options = {
	chart: {
		height: 180,
		type: \'line\',
		toolbar: {
			show: false,
		},
	},
	dataLabels: {
		enabled: false
	},
	stroke: {
		curve: \'smooth\',
		width: 2
	},
	series: [{
		name: \'تعداد\',
		data: [' . $count_Product_1 . ', ' . $count_Exportation_1 . ', ' . $Count_1 . ', ' . $count_Importation_1 . ']
	}],
	grid: {
		row: {
			colors: [\'#ffffff\'], // takes an array which will be repeated on columns
			opacity: 0.5,
		},
		xaxis: {
      lines: {
        show: false
      }
    },   
    yaxis: {
      lines: {
        show: false
      }
    },
	},
	xaxis: {
		categories: [\'محصول\', \'فاکتورهای صادره\', \'ارزش رقمی\', \'فاکتورهای وارده\'],
		// labels: {
	 //    show: false
	 //  }
	},
	colors: [\'#262b31\', \'#1a8e5f\', \'#434950\', \'#63686f\', \'#868a90\'],
	markers: {
		size: 5,
		opacity: 0.2,
		colors: ["#262b31"],
		strokeColor: "#ffffff",
		strokeWidth: 2,
		hover: {
			size: 7,
		}
	},
	tooltip: {
		y: {
			formatter: function(val) {
				return   val
			}
		}
	},
}

var chart = new ApexCharts(
	document.querySelector("#compare-expenses"),
	options
);

chart.render();

        </script>
    ';
?>
</body>

</html>