<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title>انبار / لیست انبارها </title>
    <!-- *************
        ************ Common Css Files *************
    ************ -->
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <!-- Icomoon Font Icons css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <!-- Main css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
    <!-- Data Tables -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4-custom.css"/>
    <link href="<?= base_url('Assets/') ?>vendor/datatables/buttons.bs.css" rel="stylesheet"/>
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">انبار</li>
                <li class="breadcrumb-item active">لیست انبارها</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <!-- Row start -->
            <!--Elaaaaaaaaaaaaaaaaaaaaan Staaaaaaaaaaaaaaaaart -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <!-- Edit Contact Modal -->
                    <div class="modal fade" id="editContact" tabindex="-1" role="dialog"
                         aria-labelledby="editContactLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="row gutters elanModal">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="alert-notify info">
                                        <div class="alert-notify-body">
                                            <span class="type"></span>
                                            <div class="alert-notify-title"></div>
                                            <div class=" alert-notify-text
                                    ">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editContactLabel">بروزرسانی انبار</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form class="row gutters">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="editTitle">عنوان</label>
                                                <input type="text" class="form-control" id="editTitle">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="editNumber">شماره</label>
                                                <input type="text" class="form-control" id="editNumber">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                            <div class="form-group mb-0">
                                                <label for="editDescription">توضیحات </label>
                                                <textarea class="form-control" id="editDescription"></textarea>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer custom">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-link danger btn-block"
                                                data-dismiss="modal">لغو
                                        </button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="button" value="" id="editStoreroom"
                                                class="btn btn-link success btn-block">بروزرسانی
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="action">
                    <div class="row gutters elan">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="table-container">
                        <div class="t-header">لیست انبار ها</div>
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                <tr>
                                    <th>نام انبار</th>
                                    <th>شماره انبار</th>
                                    <th> اقدامات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($Storeroom->result() as $Storeroom) {
                                    echo '
                                          <tr>
                                            <td>' . $Storeroom->storeroom_Title . '</td>
                                            <td>' . $Storeroom->storeroom_Number . '</td>
                                            <td>
                                                <div class="td-actions" id="td-actions">
                                                    <a target="_blank" href="' . base_url('Storeroom/mySR/' . $Storeroom->storeroom_Number) . '" class="icon red" data-toggle="tooltip" data-placement="top"
                                                       title="نمایش انبار">
                                                        <i class="icon-store_mall_directory"></i>
                                                    </a>
                                                    <a href="#" data-action="editStoreroom" data-id="' . $Storeroom->storeroom_Id . '" data-toggle="modal" data-target="#editContact" class="icon green" data-toggle="tooltip" data-placement="top"
                                                       title="ویرایش انبار">
                                                        <i class="icon-edit-3"></i>
                                                    </a>
                                                    <a href="#" data-action="deleteStoreroom" data-id="' . $Storeroom->storeroom_Id . '" class="icon blue" data-toggle="tooltip" data-placement="top"
                                                       title="حذف انبار ">
                                                        <i class="icon-remove_circle"></i>
                                                    </a>
                                                </div>
                                            </td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->
        </div>
        <?php $this->load->view('layout/footer'); ?>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Data Tables -->
<script src="<?= base_url('Assets/') ?>send/Storeroom/index.js"></script>

<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bootstrap.min.js"></script>

<!-- Custom Data tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/custom-datatables.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/fixedHeader.js"></script>

<!-- Download / CSV / Copy / Print -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/jszip.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/pdfmake.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/vfs_fonts.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/html5.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.print.min.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
</body>
</html>