<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title><?= $info['2'] ?> / مشاهده محصولات </title>
    <!-- *************
        ************ Common Css Files *************
    ************ -->
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <!-- Icomoon Font Icons css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <!-- Main css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
    <!-- *************
        ************ Vendor Css Files *************
    ************ -->
    <!-- DateRange css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/fontawesome-5.12.1/css/all.min.css"/>
    <!-- Bootstrap Select CSS -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/bs-select/bs-select.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap-datepicker.min.css"/>
    <!-- Data Tables -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4-custom.css"/>
    <link href="<?= base_url('Assets/') ?>vendor/datatables/buttons.bs.css" rel="stylesheet"/>


</head>

<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/storeroom_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $info['2'] ?></li>
                <li class="breadcrumb-item active">مشاهده محصولات</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">

            <!-- Row start -->
            <!--Elaaaaaaaaaaaaaaaaaaaaan Staaaaaaaaaaaaaaaaart -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <!-- Edit Contact Modal -->
                    <div class="modal fade" id="editContact" tabindex="-1" role="dialog"
                         aria-labelledby="editContactLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="row gutters elanModal">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="alert-notify info">
                                        <div class="alert-notify-body">
                                            <span class="type"></span>
                                            <div class="alert-notify-title"></div>
                                            <div class=" alert-notify-text
                                    ">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editContactLabel">بروزرسانی محصول</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form class="row gutters">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <p><code>نام</code></p>
                                                <input type="text" placeholder="نام کالا را وارد کنید "
                                                       class="form-control" id="editTitle">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <p><code>شناسه</code></p>
                                                <input type="text" placeholder="شناسه کالا را وارد کنید "
                                                       class="form-control" id="editCode">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <p><code>دسته بندی</code></p>
                                                <select id="editCategoryProduct" name="editCategoryProduct"
                                                        class="form-control"
                                                >
                                                    <?php
                                                    foreach ($Category->result() as $Category1) {
                                                        echo '
                                                    <option value="' . $Category1->category_Id . '">' . $Category1->category_Title . '</option>
                                                    ';
                                                    }
                                                    ?>

                                                </select>
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <p><code>واحد</code></p>
                                                <select id="editUnitProduct" name="editUnitProduct"
                                                        class="form-control">
                                                    <?php
                                                    foreach ($Unit->result() as $Unit2) {
                                                        echo '
                                                    <option value="' . $Unit2->unit_Id . '">' . $Unit2->unit_Title . '</option>
                                                    ';
                                                    }
                                                    ?>
                                                </select>
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="editNumber">قیمت واحد</label>
                                                <input type="text" placeholder="قیمت کالا را وارد کنید "
                                                       class="form-control" id="editNumber">
                                                <small id="editNumber" class="text-muted">
                                                    مثال 78,000 ریال
                                                </small>

                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group mb-0">
                                                <label for="editDescription">توضیحات </label>
                                                <textarea class="form-control" id="editDescription"></textarea>
                                                <small id="editDescription" class="text-muted">
                                                    حداکثر 1000 کاراکتر
                                                </small>

                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer custom">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-link danger btn-block"
                                                data-dismiss="modal">لغو
                                        </button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="button" value="" id="editProduct"
                                                class="btn btn-link success btn-block">بروزرسانی
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-5 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="row gutters elan">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="col-xl-12">
                    <div class="table-container">
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                <tr>
                                    <th>نام محصول</th>
                                    <th>شناسه محصول</th>
                                    <th>دسته بندی محصول</th>
                                    <th>واحد محصول</th>
                                    <th>قیمت محصول</th>
                                    <th>تعداد محصول</th>
                                    <th> اقدامات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($Product->result() as $Product) {
                                    echo '
                                          <tr>
                                            <td>' . $Product->product_Title . '</td>
                                            <td>' . $Product->product_Code . '</td>
                                            <td>' . $Product->category_Title . '</td>
                                            <td>' . $Product->unit_Title . '</td>
                                            <td>' . number_format($Product->product_Price) . ' ریال</td>
                                            <td>' . number_format($Product->product_Amount) . ' ' . $Product->unit_Title . '</td>
                                            <td>
                                                <div class="td-actions">
                                                    <a href="#" data-action="editProduct" data-id="' . $Product->product_Id . '" data-toggle="modal" data-target="#editContact" class="icon green" data-toggle="tooltip" data-placement="top"
                                                       title="ویرایش">
                                                        <i class="icon-edit-3"></i>
                                                    </a>
                                                    <a href="#" data-action="deleteProduct" data-id="' . $Product->product_Id . '" class="icon blue" data-toggle="tooltip" data-placement="top"
                                                       title="حذف ">
                                                        <i class="icon-remove"></i>
                                                    </a>
                                                </div>
                                            </td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <!-- Row end -->
        </div>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Input Masks JS -->
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave-custom.js"></script>
<!-- Bootstrap Select JS -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bootstrap.min.js"></script>


<!-- Custom Data tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/custom-datatables.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/fixedHeader.js"></script>

<!-- Download / CSV / Copy / Print -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/jszip.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/pdfmake.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/vfs_fonts.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/html5.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.print.min.js"></script>


<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>send/Storeroom/index.js"></script>
</body>
</html>