<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title><?= $info['2'] ?> / مشاهده لیست محصولات وارد شده </title>
    <!-- *************
        ************ Common Css Files *************
    ************ -->
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">

    <!-- Icomoon Font Icons css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">

    <!-- Main css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
    <!-- Data Tables -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4-custom.css"/>
    <link href="<?= base_url('Assets/') ?>vendor/datatables/buttons.bs.css" rel="stylesheet"/>


    <!-- *************
        ************ Vendor Css Files *************
    ************ -->
    <!-- Bootstrap Select CSS -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/bs-select/bs-select.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap-datepicker.min.css"/>

</head>

<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/storeroom_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $info['2'] ?></li>
                <li class="breadcrumb-item active">مشاهده لیست محصولات وارد شده</li>
            </ol>
            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <!-- Row start -->
            <div class="row gutters elan">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="alert-notify info">
                        <div class="alert-notify-body">
                            <span class="type"></span>
                            <div class="alert-notify-title"></div>
                            <div class=" alert-notify-text
                                    ">
                            </div>
                        </div>
                    </div>
                </div>

            </div>

            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">


                    <div class="table-container">
                        <div class="t-header">محصول های وارد شده</div>
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                <tr>
                                    <th>شماره حواله</th>
                                    <th>شماره محصول</th>
                                    <th>نام</th>
                                    <th>دسته</th>
                                    <th>قیمت</th>
                                    <th>مقدار</th>
                                    <th>تاریخ ورود</th>
                                    <th>فروشنده</th>
                                    <th>گیرنده</th>
                                    <th>اقدامات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($Importation->result() as $importation) {
                                    echo '
                                          <tr>
                                            <td>' . $importation->importation_havaleCode . '</td>
                                            <td>' . $importation->product_Code . '</td>
                                            <td>' . $importation->product_Title . '</td>
                                            <td>' . $importation->category_Title . '</td>
                                            <td>' . number_format($importation->product_Price) . ' ریال </td> 
                                            <td>' . number_format($importation->importation_Amount) . '</td>
                                            <td>' . jdate('Y/n/j', strtotime($importation->importation_Date)) . '</td>
                                            <td>' . $importation->contact_firstName . ' ' . $importation->contact_lastName . '(' . $importation->contact_companyName . ')' . '</td>
                                            <td>' . $importation->user_firstName . ' ' . $importation->user_lastName . '</td>
                                            <td>
                                                <div class="td-actions">
                                                    <a href="#" data-action="deleteImportation" data-id="' . $importation->importation_Id . '" class="icon blue" data-toggle="tooltip" data-placement="top"
                                                       title="حذف ">
                                                        <i class="icon-remove"></i>
                                                    </a>
                                                </div>
                                            </td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>
            </div>
            <!-- Row end -->

        </div>
        <!-- Main container end -->

    </div>
    <!-- Page content end -->

</div>
<!-- Page wrapper end -->

<!--**************************
    **************************
        **************************
                    Required JavaScript Files
        **************************
    **************************
**************************-->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- *************
    ************ Vendor Js Files *************
************* -->
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Bootstrap Select JS -->
<!-- Data Tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bootstrap.min.js"></script>
<!-- Input Masks JS -->
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave-custom.js"></script>
<!-- Main JS -->
<!-- Custom Data tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/custom-datatables.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/fixedHeader.js"></script>

<!-- Download / CSV / Copy / Print -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/jszip.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/pdfmake.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/vfs_fonts.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/html5.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.print.min.js"></script>

<!-- Main JS -->

<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap-datepicker.fa.min.js"></script>
<script src="<?= base_url('Assets/') ?>send/Storeroom/index.js"></script>
<script>
    $(document).ready(function () {
        $("#Date").datepicker({
            isRTL: true,
            dateFormat: "yy/m/d"
        });
    });
</script>
</body>

</html>