<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title><?= $info['2'] ?> / وارد کردن محصول </title>
    <!-- *************
        ************ Common Css Files *************
    ************ -->
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">

    <!-- Icomoon Font Icons css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">

    <!-- Main css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
    <!-- Data Tables -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4-custom.css"/>
    <link href="<?= base_url('Assets/') ?>vendor/datatables/buttons.bs.css" rel="stylesheet"/>


    <!-- *************
        ************ Vendor Css Files *************
    ************ -->
    <!-- DateRange css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/daterange/daterange.css"/>
    <!-- Bootstrap Select CSS -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/bs-select/bs-select.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap-datepicker.min.css"/>

</head>

<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/storeroom_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $info['2'] ?></li>
                <li class="breadcrumb-item active">وارد کردن محصول</li>
            </ol>
            <ul class="app-actions">
                <li>
                    <a href="#" id="reportrange">
                        <span class="range-text"></span>
                        <i class="icon-chevron-down"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Edit Contact Modal -->
                <div class="modal fade" id="findSellerModal" tabindex="1" role="dialog"
                     aria-labelledby="editContactLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="row gutters elanModal">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                <div class="alert-notify info">
                                    <div class="alert-notify-body">
                                        <span class="type"></span>
                                        <div class="alert-notify-title"></div>
                                        <div class=" alert-notify-text
                                    ">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="modal-content">
                            <div class="modal-body">
                                <!-- Row start -->
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="table-container">
                                            <div class="t-header">جستجوی فروشنده</div>
                                            <div class="table-responsive">
                                                <table id="rowSelection" class="table custom-table">
                                                    <thead>
                                                    <tr>
                                                        <th>نام فروشنده</th>
                                                        <th>نام شرکت فروشنده</th>
                                                        <th>شماره تماس فروشنده</th>
                                                        <th>ایمیل فروشنده</th>
                                                        <th> اقدامات</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                    foreach ($Seller->result() as $Seller) {
                                                        echo '
                                                      <tr>
                                                        <td>' . $Seller->contact_firstName . ' ' . $Seller->contact_lastName . '</td>
                                                        <td>' . $Seller->contact_companyName . '</td>
                                                        <td>' . $Seller->contact_Tell . '</td>
                                                        <td>' . $Seller->contact_Email . '</td>
                                                        <td>
                                                            <div class="td-actions">
                                                                <a class="icon blue" data-toggle="tooltip" data-action="findSellerPro" data-id="' . $Seller->contact_Id . '" data-placement="top"
                                                                   title="انتخاب">
                                                                    <i class="icon-select-arrows"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                      </tr>
                                    ';
                                                    }
                                                    ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                                <!-- Row end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Edit Contact Modal -->
                <div class="modal fade" id="findProductModal" tabindex="-1" role="dialog"
                     aria-labelledby="editContactLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="row gutters elanModal">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                <div class="alert-notify info">
                                    <div class="alert-notify-body">
                                        <span class="type"></span>
                                        <div class="alert-notify-title"></div>
                                        <div class=" alert-notify-text
                                    ">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="modal-content">
                            <div class="modal-body">
                                <!-- Row start -->
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="table-container">
                                            <div class="t-header">جستجوی محصول</div>
                                            <div class="table-responsive">
                                                <table id="basicExample" class="table custom-table">
                                                    <thead>
                                                    <tr>
                                                        <th>نام</th>
                                                        <th>شناسه</th>
                                                        <th>دسته بندی</th>
                                                        <th>واحد</th>
                                                        <th> اقدامات</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                    foreach ($Product->result() as $Product) {
                                                        echo '
                                                      <tr>
                                                        <td>' . $Product->product_Title . '</td>
                                                        <td>' . $Product->product_Code . '</td>
                                                        <td>' . $Product->category_Title . '</td>
                                                        <td>' . $Product->unit_Title . '</td>
                                                        <td>
                                                            <div class="td-actions">
                                                                <a class="icon blue" data-toggle="tooltip" data-action="findProductPro" data-id="' . $Product->product_Code . '" data-placement="top"
                                                                   title="انتخاب">
                                                                    <i class="icon-select-arrows"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                      </tr>
                                    ';
                                                    }
                                                    ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                                <!-- Row end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="row gutters elan">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row gutters">
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="mb-2">
                                        <p class="mx-auto"><i class="icon-plus-circle"></i> باکس اطللاعات ورودی</p>
                                    </div>
                                    <div class="form-group">
                                        <p><code>شماره حواله</code></p>
                                        <input type="text" class="form-control" id="havaleCode"
                                               placeholder="شماره حواله محصول را وارد کنید">
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <p><code>مقدار</code></p>
                                        <input type="text" class="form-control" id="Number"
                                               placeholder="مقدار محصول را وارد کنید">
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <p><code>ارسال کننده</code>
                                            <a href="#" data-toggle="modal"
                                               data-target="#findSellerModal"
                                               class="icon blue"
                                               data-toggle="tooltip" data-placement="top"
                                               title="انتخاب از لیست ">
                                                ( انتخاب از لیست )
                                        </p>
                                        <input type="text" class="form-control" id="Sender" readonly
                                               placeholder="تحویل دهنده محصول را وارد کنید">
                                    </div>
                                    <div class="form-group">
                                        </a>

                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <label for="Description">توضیحات </label>
                                        <textarea class="form-control" id="Description" placeholder="توضیحات محصول"
                                                  maxlength="140"
                                                  rows="3"></textarea>
                                        <div class="form-text text-muted"><p></p>حداکثر 1000 کاراکتر</div>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <p><code>تاریخ</code></p>
                                        <input type="text" class="form-control" id="Date"
                                               placeholder="کلیک کنید" value="<?= $Date ?>">
                                    </div>
                                </div>
                                <button type="submit" id="CreateImportation" value=""
                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                    ثبت ورود محصول
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-3 col-md-12 col-sm-12 col-12">
                    <div class="card color_1">
                        <div class="card-body">
                            <div class="mb-2">
                                <p class="mx-auto"><i class="icon-info"></i> باکس محصول جستجو شده </p>
                            </div>

                            <div class="account-settings">
                                <div class="user-profile">
                                    <h4 class="user-name" id="findProductTitle"> نام = ؟ </h4>
                                    <h7 class="user-email" id="findProductCategory">دسته = ؟</h7>
                                </div>
                                <div class="setting-links">
                                    <a id="findProductPrice">
                                        <i class="icon-dollar-sign"></i>
                                        <p>قیمت = ؟</p>
                                    </a>
                                    <a id="findProductUnit">
                                        <i class="icon-package"></i>
                                        <p>واحد = ؟</p>
                                    </a>
                                    <a id="findProductAmount">
                                        <i class="icon-line-graph"></i>
                                        <p>موجودی = ؟</p>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="row gutters elanFind">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row gutters">
                                <div class="mb-2">
                                    <p class="mx-auto"><i class="icon-search"></i> باکس جستجوی محصول </p>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <label for="Code1">شناسه</label>
                                        <input type="text" class="form-control" id="Code1"
                                               placeholder="شناسه محصول را وارد کنید">
                                    </div>
                                </div>
                                <button type="submit" id="findProduct"
                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                    جستجو
                                </button>
                                <button type="submit" id="findProduct" data-toggle="modal"
                                        data-target="#findProductModal"
                                        class="btn btn-outline-primary btn-rounded my-2 p-2 mx-auto">
                                    جستجوی پیشرفته
                                </button>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!-- Row end -->
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">


                    <div class="table-container">
                        <div class="t-header">محصول های وارد شده</div>
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                <tr>
                                    <th>شماره حواله</th>
                                    <th>شماره محصول</th>
                                    <th>نام</th>
                                    <th>دسته</th>
                                    <th>قیمت</th>
                                    <th>مقدار</th>
                                    <th>تاریخ ورود</th>
                                    <th>فروشنده</th>
                                    <th>گیرنده</th>
                                    <th>اقدامات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($Importation->result() as $importation) {
                                    echo '
                                          <tr>
                                            <td>' . $importation->importation_havaleCode . '</td>
                                            <td>' . $importation->product_Code . '</td>
                                            <td>' . $importation->product_Title . '</td>
                                            <td>' . $importation->category_Title . '</td>
                                            <td>' . number_format($importation->product_Price) . ' ریال </td> 
                                            <td>' . number_format($importation->importation_Amount) . '</td>
                                            <td>' . jdate('Y/n/j', strtotime($importation->importation_Date)) . '</td>
                                            <td>' . $importation->contact_firstName . ' ' . $importation->contact_lastName . '(' . $importation->contact_companyName . ')' . '</td>
                                            <td>' . $importation->user_firstName . ' ' . $importation->user_lastName . '</td>
                                            <td>
                                                <div class="td-actions">
                                                    <a href="#" data-action="deleteImportation" data-id="' . $importation->importation_Id . '" class="icon blue" data-toggle="tooltip" data-placement="top"
                                                       title="حذف ">
                                                        <i class="icon-remove"></i>
                                                    </a>
                                                </div>
                                            </td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>
            </div>
            <!-- Row end -->

        </div>
        <!-- Main container end -->

    </div>
    <!-- Page content end -->

</div>
<!-- Page wrapper end -->

<!--**************************
    **************************
        **************************
                    Required JavaScript Files
        **************************
    **************************
**************************-->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- *************
    ************ Vendor Js Files *************
************* -->
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Daterange -->
<script src="<?= base_url('Assets/') ?>vendor/daterange/daterange.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/daterange/custom-daterange.js"></script>
<!-- Bootstrap Select JS -->
<!-- Data Tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bootstrap.min.js"></script>
<!-- Custom Data tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/custom-datatables.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/fixedHeader.js"></script>

<!-- Input Masks JS -->
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave-custom.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap-datepicker.fa.min.js"></script>
<script src="<?= base_url('Assets/') ?>send/Storeroom/index.js"></script>
<script>
    $(document).ready(function () {
        $("#Date").datepicker({
            isRTL: true,
            dateFormat: "yy/m/d"
        });
    });
</script>
</body>

</html>