<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title><?= $info['2'] ?> / خارج کردن محصول </title>
    <!-- *************
        ************ Common Css Files *************
    ************ -->
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">

    <!-- Icomoon Font Icons css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">

    <!-- Main css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
    <!-- Data Tables -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4-custom.css"/>
    <link href="<?= base_url('Assets/') ?>vendor/datatables/buttons.bs.css" rel="stylesheet"/>
    <!-- Bootstrap Select CSS -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/bs-select/bs-select.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap-datepicker.min.css"/>

</head>

<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/storeroom_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $info['2'] ?></li>
                <li class="breadcrumb-item active">خارج کردن محصول</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Edit Contact Modal -->
                <div class="modal fade" id="findBuyerModal" tabindex="1" role="dialog"
                     aria-labelledby="editContactLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="row gutters elanModal">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                <div class="alert-notify info">
                                    <div class="alert-notify-body">
                                        <span class="type"></span>
                                        <div class="alert-notify-title"></div>
                                        <div class=" alert-notify-text
                                    ">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="modal-content">
                            <div class="modal-body">
                                <!-- Row start -->
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="table-container">
                                            <div class="t-header">جستجوی خریدار</div>
                                            <div class="table-responsive">
                                                <table id="rowSelection" class="table custom-table">
                                                    <thead>
                                                    <tr>
                                                        <th>نام خریدار</th>
                                                        <th>نام شرکت خریدار</th>
                                                        <th>شماره تماس خریدار</th>
                                                        <th>ایمیل خریدار</th>
                                                        <th> اقدامات</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                    foreach ($Buyer->result() as $Buyer) {
                                                        echo '
                                                      <tr>
                                                        <td>' . $Buyer->contact_firstName . ' ' . $Buyer->contact_lastName . '</td>
                                                        <td>' . $Buyer->contact_companyName . '</td>
                                                        <td>' . $Buyer->contact_Tell . '</td>
                                                        <td>' . $Buyer->contact_Email . '</td>
                                                        <td>
                                                            <div class="td-actions">
                                                                <a class="icon blue" data-toggle="tooltip" data-action="findBuyerPro" data-id="' . $Buyer->contact_Id . '" data-placement="top"
                                                                   title="انتخاب">
                                                                    <i class="icon-select-arrows"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                      </tr>
                                    ';
                                                    }
                                                    ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                                <!-- Row end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                <!-- Edit Contact Modal -->
                <div class="modal fade" id="findProductModal" tabindex="-1" role="dialog"
                     aria-labelledby="editContactLabel" aria-hidden="true">
                    <div class="modal-dialog modal-xl" role="document">
                        <div class="row gutters elanModal">
                            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                <div class="alert-notify info">
                                    <div class="alert-notify-body">
                                        <span class="type"></span>
                                        <div class="alert-notify-title"></div>
                                        <div class=" alert-notify-text
                                    ">
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="modal-content">
                            <div class="modal-body">
                                <!-- Row start -->
                                <div class="row gutters">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                        <div class="table-container">
                                            <div class="t-header">جستجوی محصول</div>
                                            <div class="table-responsive">
                                                <table id="basicExample" class="table custom-table">
                                                    <thead>
                                                    <tr>
                                                        <th>نام</th>
                                                        <th>شناسه</th>
                                                        <th>دسته بندی</th>
                                                        <th>واحد</th>
                                                        <th> اقدامات</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php
                                                    foreach ($Product->result() as $Product) {
                                                        echo '
                                                      <tr>
                                                        <td>' . $Product->product_Title . '</td>
                                                        <td>' . $Product->product_Code . '</td>
                                                        <td>' . $Product->category_Title . '</td>
                                                        <td>' . $Product->unit_Title . '</td>
                                                        <td>
                                                            <div class="td-actions">
                                                                <a class="icon blue" data-toggle="tooltip" data-action="findProductPro" data-id="' . $Product->product_Code . '" data-placement="top"
                                                                   title="انتخاب">
                                                                    <i class="icon-select-arrows"></i>
                                                                </a>
                                                            </div>
                                                        </td>
                                                      </tr>
                                    ';
                                                    }
                                                    ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>


                                    </div>
                                </div>
                                <!-- Row end -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="row gutters elan">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row gutters">
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="mb-2">
                                        <p class="mx-auto"><i class="icon-plus-circle"></i> باکس اطللاعات خروجی</p>
                                    </div>
                                    <div class="form-group">
                                        <p><code>شماره حواله</code></p>
                                        <input type="text" class="form-control" id="havaleCode"
                                               placeholder="شماره حواله کالا را وارد کنید">
                                        <small>این فیلد نباید خالی باشد</small>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <p><code>مقدار</code></p>
                                        <input type="text" class="form-control" id="Number"
                                               placeholder="مقدار کالا را وارد کنید">
                                        <small>این فیلد نباید خالی باشد</small>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <p><code>تحویل گیرنده</code>
                                            <a href="#" data-toggle="modal"
                                               data-target="#findBuyerModal"
                                               class="icon blue"
                                               data-toggle="tooltip" data-placement="top"
                                               title="انتخاب از لیست ">
                                                ( انتخاب از لیست )</a>
                                        </p>
                                        <input type="text" class="form-control" id="Receiver" readonly
                                               placeholder="تحویل گیرنده کالا را وارد کنید">
                                        <small>این فیلد نباید خالی باشد</small>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <label for="Description">توضیحات </label>
                                        <textarea class="form-control" id="Description" placeholder="توضیحات کالا"
                                                  maxlength="140"
                                                  rows="3"></textarea>
                                        <div class="form-text text-muted"><p></p>حداکثر 1000 کاراکتر</div>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <p><code>تاریخ</code></p>
                                        <input type="text" class="form-control" id="Date"
                                               placeholder="کلیک کنید" value="<?= $Date ?>">
                                        <small>این فیلد نباید خالی باشد</small>
                                    </div>
                                </div>
                                <button type="submit" id="CreateExportation" value=""
                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                    ثبت خروج کالا
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-3 col-md-12 col-sm-12 col-12">
                    <div class="card color_1">
                        <div class="card-body">
                            <div class="mb-2">
                                <p class="mx-auto"><i class="icon-info"></i> باکس کالای جستجو شده </p>
                            </div>

                            <div class="account-settings">
                                <div class="user-profile">
                                    <h4 class="user-name" id="findProductTitle"> نام = ؟ </h4>
                                    <h7 class="user-email" id="findProductCategory">دسته = ؟</h7>
                                </div>
                                <div class="setting-links">
                                    <a id="findProductPrice">
                                        <i class="icon-dollar-sign"></i>
                                        <p>قیمت = ؟</p>
                                    </a>
                                    <a id="findProductUnit">
                                        <i class="icon-package"></i>
                                        <p>واحد = ؟</p>
                                    </a>
                                    <a id="findProductAmount">
                                        <i class="icon-line-graph"></i>
                                        <p>موجودی = ؟</p>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="row gutters elanFind">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                    <div class="card">
                        <div class="card-body">
                            <div class="row gutters">
                                <div class="mb-2">
                                    <p class="mx-auto"><i class="icon-search"></i> باکس جستجوی کالا </p>
                                </div>
                                <div class="col-xl-12 col-lglg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <label for="Code1">شناسه</label>
                                        <input type="text" class="form-control" id="Code1"
                                               placeholder="شناسه کالا را وارد کنید">
                                    </div>
                                </div>
                                <button type="submit" id="findProduct"
                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                    جستجو
                                </button>
                                <button type="submit" id="findProduct" data-toggle="modal"
                                        data-target="#findProductModal"
                                        class="btn btn-outline-primary btn-rounded my-2 p-2 mx-auto">
                                    جستجوی پیشرفته
                                </button>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!-- Row end -->
            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">


                    <div class="table-container">
                        <div class="t-header">محصول های خارج شده</div>
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                <tr>
                                    <th>شماره حواله</th>
                                    <th>شماره کالا</th>
                                    <th>نام</th>
                                    <th>دسته</th>
                                    <th>قیمت</th>
                                    <th>مقدار</th>
                                    <th>تاریخ خروج</th>
                                    <th>تحویل دهنده</th>
                                    <th>تحویل گیرنده</th>
                                    <th>اقدامات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($Exportation->result() as $exportation) {
                                    echo '
                                          <tr>
                                            <td>' . $exportation->exportation_havaleCode . '</td>
                                            <td>' . $exportation->product_Code . '</td>
                                            <td>' . $exportation->product_Title . '</td>
                                            <td>' . $exportation->category_Title . '</td>
                                            <td>' . number_format($exportation->product_Price) . ' ریال</td>
                                            <td>' . number_format($exportation->exportation_Amount) . '</td>
                                            <td>' . jdate('Y/n/j', strtotime($exportation->exportation_Date)) . '</td>
                                            <td>' . $exportation->user_firstName . ' ' . $exportation->user_lastName . '</td>
                                            <td>' . $exportation->contact_firstName . ' ' . $exportation->contact_lastName . '(' . $exportation->contact_companyName . ')' . '</td>
                                            <td>
                                                <div class="td-actions">
                                                    <a href="#" data-action="deleteExportation" data-id="' . $exportation->exportation_Id . '" class="icon blue" data-toggle="tooltip" data-placement="top"
                                                       title="حذف ">
                                                        <i class="icon-remove"></i>
                                                    </a>
                                                </div>
                                            </td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>


                </div>
            </div>
            <!-- Row end -->

        </div>
        <!-- Main container end -->

    </div>
    <!-- Page content end -->

</div>
<!-- Page wrapper end -->

<!--**************************
    **************************
        **************************
                    Required JavaScript Files
        **************************
    **************************
**************************-->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- *************
    ************ Vendor Js Files *************
************* -->
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Bootstrap Select JS -->
<script src="<?= base_url('Assets/') ?>vendor/bs-select/bs-select.min.js"></script>
<!-- Data Tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bootstrap.min.js"></script>
<!-- Custom Data tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/custom-datatables.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/fixedHeader.js"></script>
<!-- Input Masks JS -->
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave-custom.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap-datepicker.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap-datepicker.fa.min.js"></script>
<script src="<?= base_url('Assets/') ?>send/Storeroom/index.js"></script>
<script>
    $(document).ready(function () {
        $("#Date").datepicker({
            isRTL: true,
            dateFormat: "yy/m/d"
        });
    });
</script>
</body>

</html>