<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <title>داشبورد / ساخت انبار </title>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">انبار</li>
                <li class="breadcrumb-item active">ساخت انبار</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Storeroom') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?= base_url('Document') ?>" target="_blank" data-toggle="tooltip" data-placement="top"
                       title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <!-- Row start -->
            <!--Elaaaaaaaaaaaaaaaaaaaaan Staaaaaaaaaaaaaaaaart -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <!-- Edit Contact Modal -->
                    <div class="modal fade" id="editContact" tabindex="-1" role="dialog"
                         aria-labelledby="editContactLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="row gutters elanModal">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="alert-notify info">
                                        <div class="alert-notify-body">
                                            <span class="type"></span>
                                            <div class="alert-notify-title"></div>
                                            <div class=" alert-notify-text
                                    ">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editContactLabel">بروزرسانی انبار</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form class="row gutters">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="editTitle">عنوان</label>
                                                <input type="text" class="form-control" id="editTitle">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="editNumber">شماره</label>
                                                <input type="text" class="form-control" id="editNumber">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                                            <div class="form-group mb-0">
                                                <label for="editDescription">توضیحات </label>
                                                <textarea class="form-control" id="editDescription"></textarea>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="modal-footer custom">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-link danger btn-block"
                                                data-dismiss="modal">لغو
                                        </button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="button" value="" id="editStoreroom"
                                                class="btn btn-link success btn-block">بروزرسانی
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-5 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="row gutters elan">
                        <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                            <div class="alert-notify info">
                                <div class="alert-notify-body">
                                    <span class="type"></span>
                                    <div class="alert-notify-title"></div>
                                    <div class=" alert-notify-text
                                    ">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <div class="row gutters">
                                <div class="col-xl-12 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <code>عنوان</code>
                                        <input type="text" class="form-control" id="Title" name="Title"
                                               placeholder="عنوان انبار را وارد کنید">
                                        <small>این فیلد نباید خالی باشد</small>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <code>شماره</code>
                                        <input type="text" class="form-control" placeholder="شماره انبار را وارد کنید"
                                               name="Number" id="Number"/>
                                        <small>این فیلد نباید خالی باشد ، مثلا 3</small>
                                    </div>
                                </div>
                                <div class="col-xl-12 col-lg-4 col-md-4 col-sm-4 col-12">
                                    <div class="form-group">
                                        <label for="Description">توضیحات </label>
                                        <textarea class="form-control" id="Description" name="Description"
                                                  placeholder="پیام" maxlength="140"
                                                  rows="3"></textarea>
                                        <div class="form-text text-muted"><p></p>حداکثر 1000 کاراکتر</div>
                                    </div>
                                </div>
                                <button type="submit" id="createStoreroom"
                                        class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                    ساخت انبار
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="table-container">
                        <div class="table-responsive">
                            <table class="table custom-table m-0 text-center">
                                <thead>
                                <tr>
                                    <th>نام انبار</th>
                                    <th>شماره انبار</th>
                                    <th> اقدامات</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($Storeroom as $Storeroom) {
                                    echo '
                                          <tr>
                                            <td>' . $Storeroom->storeroom_Title . '</td>
                                            <td>' . $Storeroom->storeroom_Number . '</td>
                                            <td>
                                                <div class="td-actions">
                                                    <a target="_blank" href="' . base_url('Storeroom/mySR/' . $Storeroom->storeroom_Number) . '" class="icon red" data-toggle="tooltip" data-placement="top"
                                                       title="نمایش انبار">
                                                        <i class="icon-store_mall_directory"></i>
                                                    </a>
                                                    <a href="#" data-action="editStoreroom" data-id="' . $Storeroom->storeroom_Id . '" data-toggle="modal" data-target="#editContact" class="icon green" data-toggle="tooltip" data-placement="top"
                                                       title="ویرایش انبار">
                                                        <i class="icon-edit-3"></i>
                                                    </a>
                                                    <a href="#" data-action="deleteStoreroom" data-id="' . $Storeroom->storeroom_Id . '" class="icon blue" data-toggle="tooltip" data-placement="top"
                                                       title="حذف انبار ">
                                                        <i class="icon-remove_circle"></i>
                                                    </a>
                                                </div>
                                            </td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                                <tfoot>
                                <tr>
                                    <td colspan="5" class="text-center">
                                        <a target="_blank" href="<?= base_url('Storeroom/Storerooms') ?>" class="link">
                                            مشاهده بیشتر </a>
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
            <!-- Row end -->

        </div>
        <?php $this->load->view('layout/footer'); ?>

        <!-- Main container end -->
    </div>
    <!-- Page content end -->

</div>
<!-- Page wrapper end -->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Input Masks JS -->
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/input-masks/cleave-custom.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>send/Storeroom/index.js"></script>
</body>
</html>