<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title>داشبورد / اعلان ها </title>
    <!-- *************
        ************ Common Css Files *************
    ************ -->
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <!-- Icomoon Font Icons css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <!-- Main css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
    <!-- Data Tables -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4.css"/>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bs4-custom.css"/>
    <link href="<?= base_url('Assets/') ?>vendor/datatables/buttons.bs.css" rel="stylesheet"/>
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">داشبورد</li>
                <li class="breadcrumb-item active">اعلان ها</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?=base_url('Storeroom')?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?=base_url('Document')?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">
            <!-- Row start -->
            <!--Elaaaaaaaaaaaaaaaaaaaaan Staaaaaaaaaaaaaaaaart -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="action">
                    <div class="table-container">
                        <div class="t-header">لیست اعلان ها</div>
                        <div class="table-responsive">
                            <table id="copy-print-csv" class="table custom-table">
                                <thead>
                                <tr>
                                    <th>نام کاربر</th>
                                    <th>توضیحات</th>
                                    <th>تاریخ</th>
                                    <th>ساعت</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php
                                foreach ($event as $event) {
                                    echo '
                                          <tr>
                                            <td>' . $event->user_firstName . ' ' . $event->user_lastName . '</td>
                                            <td>' . $event->event_Description . '</td>
                                            <td>' . $event->event_Date . '</td>
                                            <td>' . $event->event_Time . '</td>
                                          </tr>
                                    ';
                                }
                                ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->
        </div>
        <?php $this->load->view('layout/footer'); ?>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<!-- Required jQuery first, then Bootstrap Bundle JS -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<!-- Slimscroll JS -->
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/dataTables.bootstrap.min.js"></script>
<!-- Custom Data tables -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/custom-datatables.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/custom/fixedHeader.js"></script>
<!-- Download / CSV / Copy / Print -->
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/jszip.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/pdfmake.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/vfs_fonts.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/html5.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/datatables/buttons.print.min.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
</body>
</html>