<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <title>سیستم جامع انبارداری ماه - داشبورد</title>
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">

        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">اسکریپت انبارداری ماه</li>
                <li class="breadcrumb-item active">داشبورد </li>
            </ol>
            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?=base_url('Storeroom')?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?=base_url('Document')?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>
            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-store_mall_directory"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Storeroom); ?></h3>
                            <p>انبار</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-verified_user"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_StoreUser); ?></h3>
                            <p>انباردار</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-package"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Product) ?></h3>
                            <p>کالا</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon">
                            <i class="icon-contact_mail"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= $count_Contact ?></h3>
                            <p>مخاطب</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon primary">
                            <i class="icon-users"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Buyer) ?> </h3>
                            <p>مشتری</p>
                        </div>
                    </div>
                </div>
                <div class="col-xl-2 col-lg-4 col-md-4 col-sm-4 col-6">
                    <div class="info-tiles">
                        <div class="info-icon secondary">
                            <i class="icon-users"></i>
                        </div>
                        <div class="stats-detail">
                            <h3><?= number_format($count_Seller) ?></h3>
                            <p>فروشنده</p>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row ends -->
            <!-- Row starts -->
            <div class="row gutters justify-content-center">
                <div class="col-xl-8 col-lg-9 col-md-12 col-sm-12 col-12">
                    <!-- Row starts -->
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">نمودار فاکتورهای صادره و خارجه</div>
                        </div>
                        <div class="card-body">
                            <div id="basic-column-graph" class="primary-graph"></div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-3 col-md-12 col-sm-12 col-12">
                    <div class="launch-box h-180">
                        <h6> دیروز</h6>
                        <p><?= jdate('d F Y', strtotime("-1 days")) ?></p>
                        <h2>آمار ورود و خروج </h2>
                    </div>
                    <div class="card">
                        <div class="card-header">
                            <div class="card-title">ارزش مالی و رقمی انبار</div>
                        </div>
                        <div class="card-body">
                            <div id="basic-donut-graph-monochrome"></div>
                        </div>
                    </div>


                </div>
            </div>
        </div>
        <?php $this->load->view('layout/footer'); ?>
        <!-- Main container end -->
    </div>
    <!-- Page content end -->
</div>
<!-- Page wrapper end -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<!-- Apex Charts -->
<script src="<?= base_url('Assets/') ?>vendor/apex/apexcharts.min.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<?php
echo "
<script>
    var options = {
        chart: {
            height: 350,
            type: 'bar',
        },
        plotOptions: {
            bar: {
                horizontal: false,
                endingShape: 'rounded',
                columnWidth: '22%',
            },
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            show: true,
            width: 1,
            colors: ['transparent']
        },
        series: [{
            name: 'فاکتور ورودی ',
            data: ['" . $Count_Importation_now . "', '" . $Count_Importation_1 . "', '" . $Count_Importation_2 . "', '" . $Count_Importation_3 . "', '" . $Count_Importation_4 . "', '" . $Count_Importation_5 . "', '" . $Count_Importation_6 . "']
        }, {
            name: 'فاکتور خروجی',
            data: ['" . $Count_Exportation_now . "', '" . $Count_Exportation_1 . "', '" . $Count_Exportation_2 . "', '" . $Count_Exportation_3 . "', '" . $Count_Exportation_4 . "', '" . $Count_Exportation_5 . "', '" . $Count_Exportation_6 . "']
        }],
        xaxis: {
            categories: ['امروز', 'دیروز', '" . jdate('Y/m/d', strtotime("-2 days")) . "', '" . jdate('Y/m/d', strtotime("-3 days")) . "', '" . jdate('Y/m/d', strtotime("-4 days")) . "', '" . jdate('Y/m/d', strtotime("-5 days")) . "', '" . jdate('Y/m/d', strtotime("-6 days")) . "'],
        },
        yaxis: {
            title: {
                text: 'تعداد ( فاکتور )'
            }
        },
        fill: {
            opacity: 1
        },
        tooltip: {
            y: {
                formatter: function (val) {
                    return \"با \" + val + \" عدد\"
                }
            }
        },
        grid: {
            row: {
                colors: ['#f5f9fe', '#ffffff'], // takes an array which will be repeated on columns
                opacity: 0.5
            },
        },
        colors: ['#1a8e5f', '#262b31', '#434950', '#63686f', '#868a90'],
    }
    var chart = new ApexCharts(
        document.querySelector(\"#basic-column-graph\"),
        options
    );
    chart.render();
</script>

";
echo "
<script>
var options = {
    chart: {
        width: 320,
        type: 'donut',
    },
    series: [" . ($AllPrice / 1000) . ", " . $AllCount . "],
    labels: [\"ارزش مالی انبار\", \"ارزش رقمی انبار\"],
    theme: {
        monochrome: {
            enabled: true,
            color: '#1a8e5f',
        }
    },
    title: {
        text: \"فروش هفتگی\",
    },
    responsive: [{
        breakpoint: 580,
        options: {
            chart: {
                width: 200
            },
            legend: {
                position: 'bottom'
            }
        }
    }],
    stroke: {
        width: 0,
    },
}
var chart = new ApexCharts(
    document.querySelector(\"#basic-donut-graph-monochrome\"),
    options
);
chart.render();
</script>

";
?>

</body>
</html>