<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- Meta -->
    <meta name="description" content="Responsive Bootstrap4 Dashboard Template">
    <meta name="author" content="jafarabbasi">
    <link rel="shortcut icon" href="img/fav.png"/>
    <!-- Title -->
    <title> داشبورد / مخاطب ها</title>
    <!-- Bootstrap css -->
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/bootstrap.min.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>fonts/style.css">
    <link rel="stylesheet" href="<?= base_url('Assets/') ?>css/main-light-color.css">
</head>
<body>
<?php $this->load->view('layout/loader') ?>
<!-- Page wrapper start -->
<div class="page-wrapper">
    <?php $this->load->view('layout/dashboard_sidebar') ?>
    <!-- Page content start  -->
    <div class="page-content">
        <?php $this->load->view('layout/header') ?>
        <!-- Page header start -->
        <div class="page-header">
            <ol class="breadcrumb">
                <li class="breadcrumb-item">داشبورد</li>
                <li class="breadcrumb-item active">مخاطب ها</li>
            </ol>

            <ul class="app-actions">
                <li>
                    <a id="reportrange">
                        <span class="range- pull-left"><?= jdate('d F Y', strtotime("now")) ?></span>
                        <span class="range-text pull-right"><?=
                            ' - ' . date("F d, Y") ?></span>
                    </a>
                </li>
                <li>
                    <a href="<?=base_url('Storeroom')?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="مشاهده انبار ها">
                        <i class="icon-store_mall_directory"></i>
                    </a>
                </li>
                <li>
                    <a href="<?=base_url('Document')?>" target="_blank" data-toggle="tooltip" data-placement="top" title="" data-original-title="راهنمای سیستم انبارداری">
                        <i class="icon-info"></i>
                    </a>
                </li>            </ul>
        </div>
        <!-- Page header end -->

        <!-- Main container start -->
        <div class="main-container">

            <!-- Row start -->
            <div class="row gutters elan">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                    <div class="alert-notify info">
                        <div class="alert-notify-body">
                            <span class="type"></span>
                            <div class="alert-notify-title"></div>
                            <div class=" alert-notify-text">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row gutters">

                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="text-right mb-3">
                        <!-- Button trigger modal -->
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#addNewContact">
                            افزودن مخاطب جدید
                        </button>

                        <!-- Modal -->
                        <div class="modal fade" id="addNewContact" tabindex="-1" role="dialog"

                             aria-labelledby="addNewContactLabel" aria-hidden="true">

                            <div class="modal-dialog" role="document">
                                <div class="row gutters elanModal">
                                    <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                        <div class="alert-notify info">
                                            <div class="alert-notify-body">
                                                <span class="type"></span>
                                                <div class="alert-notify-title"></div>
                                                <div class=" alert-notify-text">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="addNewContactLabel">مخاطب جدید</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <form class="row gutters" id="CreateContact" method="post">
                                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="form-group">
                                                    <p><code>نام :</code></p>
                                                    <input type="text" class="form-control" name="firstName"
                                                           id="firstName">
                                                    <small>این فیلد نباید خالی باشد</small>

                                                </div>
                                                <div class="form-group">
                                                    <p><code>نام خانوادگی :</code></p>
                                                    <input type="text" class="form-control" name="lastName"
                                                           id="lastName">
                                                    <small>این فیلد نباید خالی باشد</small>

                                                </div>
                                                <div class="form-group">
                                                    <label for="lastName">نام حقوقی ( شرکت ) :</label>
                                                    <input type="text" class="form-control" name="companyName"
                                                           id="companyName">
                                                </div>
                                                <div class="form-group">
                                                    <p><code>شماره ثابت :</code></p>
                                                    <input type="text" class="form-control" name="Tell"
                                                           id="Tell">
                                                    <small>این فیلد نباید خالی باشد</small>

                                                </div>
                                                <div class="form-group">
                                                    <p><code>شماره موبایل :</code></p>
                                                    <input type="text" class="form-control" name="Mobile" id="Mobile">
                                                    <small>این فیلد نباید خالی باشد</small>
                                                </div>
                                            </div>
                                            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                                <div class="form-group">
                                                    <label for="userName">آدرس :</label>
                                                    <textarea class="form-control" id="Address"
                                                              name="Address"></textarea>
                                                </div>
                                                <div class="form-group">
                                                    <label for="Mobile">ایمیل :</label>
                                                    <input type="text" class="form-control" name="Email" id="Email">
                                                </div>
                                                <div class="form-group">
                                                    <label for="Mobile">تلگرام :</label>
                                                    <input type="text" class="form-control" name="Telegram"
                                                           id="Telegram">
                                                </div>
                                                <div class="form-group">
                                                    <label for="Mobile">واتس اپ :</label>
                                                    <input type="text" class="form-control" name="whatsApp"
                                                           id="whatsApp">
                                                </div>
                                                <div class="form-group">
                                                    <p><code>نوع مخاطب</code></p>
                                                    <select id="AccessEdit" class="form-control selectpicker"
                                                            name="Type">
                                                        <option value="">یک گزینه را انتخاب کنید</option>
                                                        <option value="1">مشتری</option>
                                                        <option value="2">فروشنده</option>
                                                        <option value="3">مخاطب</option>
                                                        <option value="4">مشتری و فروشنده</option>
                                                    </select>
                                                </div>
                                            </div>
                                    </div>
                                    <div class="modal-footer custom">
                                        <div class="left-side">
                                            <button type="button" class="btn btn-link danger btn-block"
                                                    data-dismiss="modal">لغو
                                            </button>
                                        </div>
                                        <div class="divider"></div>
                                        <div class="right-side">
                                            <button type="submit"
                                                    class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                                افزودن مخاطب
                                            </button>
                                        </div>
                                    </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Row end -->

            <!-- Row start -->
            <div class="row gutters">
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <!-- Edit Contact Modal -->
                    <div class="modal fade" id="editContact" tabindex="-1" role="dialog"
                         aria-labelledby="editContactLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="row gutters elanModal">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="alert-notify info">
                                        <div class="alert-notify-body">
                                            <span class="type"></span>
                                            <div class="alert-notify-title"></div>
                                            <div class=" alert-notify-text">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editContactLabel">ویرایش مخاطب</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form class="row gutters" id="EditContact" method="post">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <p><code>نام :</code></p>
                                                <input type="text" class="form-control" name="firstNameEdit"
                                                       id="firstNameEdit">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                            <div class="form-group">
                                                <p><code>نام خانوادگی :</code></p>
                                                <input type="text" class="form-control" name="lastNameEdit"
                                                       id="lastNameEdit">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                            <div class="form-group">
                                                <label for="lastName">نام حقوقی ( شرکت ) :</label>
                                                <input type="text" class="form-control" name="companyNameEdit"
                                                       id="companyNameEdit">
                                            </div>
                                            <div class="form-group">
                                                <p><code>شماره ثابت :</code></p>
                                                <input type="text" class="form-control" name="TellEdit"
                                                       id="TellEdit">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                            <div class="form-group">
                                                <p><code>شماره موبایل :</code></p>
                                                <input type="text" class="form-control" name="MobileEdit"
                                                       id="MobileEdit">
                                                <small>این فیلد نباید خالی باشد</small>
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="userName">آدرس :</label>
                                                <textarea class="form-control" id="AddressEdit"
                                                          name="AddressEdit"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="Mobile">ایمیل :</label>
                                                <input type="text" class="form-control" name="EmailEdit" id="EmailEdit">
                                            </div>
                                            <div class="form-group">
                                                <label for="Mobile">تلگرام :</label>
                                                <input type="text" class="form-control" name="TelegramEdit"
                                                       id="TelegramEdit">
                                            </div>
                                            <div class="form-group">
                                                <label for="Mobile">واتس اپ :</label>
                                                <input type="text" class="form-control" name="whatsAppEdit"
                                                       id="whatsAppEdit">
                                            </div>
                                            <div class="form-group">
                                                <p><code>نوع مخاطب</code></p>
                                                <select id="TypeEdit" class="form-control selectpicker"
                                                        name="TypeEdit">
                                                    <option value="1">مشتری</option>
                                                    <option value="2">فروشنده</option>
                                                    <option value="3">مخاطب</option>
                                                    <option value="4">مشتری و فروشنده</option>
                                                </select>
                                            </div>

                                        </div>
                                </div>
                                <div class="modal-footer custom">
                                    <div class="left-side">
                                        <button type="button" class="btn btn-link danger btn-block"
                                                data-dismiss="modal">لغو
                                        </button>
                                    </div>
                                    <div class="divider"></div>
                                    <div class="right-side">
                                        <button type="submit" id="EditContactbtn"
                                                class="btn btn-outline-primary btn-rounded my-1 p-1 mx-auto">
                                            بروزرسانی مخاطب
                                        </button>
                                    </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="modal fade" id="showContact" tabindex="-1" role="dialog"
                         aria-labelledby="editContactLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="row gutters elanModal">
                                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
                                    <div class="alert-notify info">
                                        <div class="alert-notify-body">
                                            <span class="type"></span>
                                            <div class="alert-notify-title"></div>
                                            <div class=" alert-notify-text">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="editContactLabel">مشاهده مخاطب</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <form class="row gutters" id="EditContact" method="post">
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <p><code>نام :</code></p>
                                                <input type="text" class="form-control" disabled name="firstNameEdit"
                                                       id="firstNameshow">
                                            </div>
                                            <div class="form-group">
                                                <p><code>نام خانوادگی :</code></p>
                                                <input type="text" class="form-control" disabled name="lastNameEdit"
                                                       id="lastNameshow">
                                            </div>
                                            <div class="form-group">
                                                <label for="lastName">نام حقوقی ( شرکت ) :</label>
                                                <input type="text" class="form-control" disabled name="companyNameEdit"
                                                       id="companyNameshow">
                                            </div>
                                            <div class="form-group">
                                                <p><code>شماره ثابت :</code></p>
                                                <input type="text" class="form-control" disabled name="TellEdit"
                                                       id="Tellshow">
                                            </div>
                                            <div class="form-group">
                                                <p><code>شماره موبایل :</code></p>
                                                <input type="text" class="form-control" disabled name="MobileEdit"
                                                       id="Mobileshow">
                                            </div>
                                        </div>
                                        <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 col-12">
                                            <div class="form-group">
                                                <label for="userName">آدرس :</label>
                                                <textarea class="form-control" disabled id="Addressshow"
                                                          name="AddressEdit"></textarea>
                                            </div>
                                            <div class="form-group">
                                                <label for="Mobile">ایمیل :</label>
                                                <input type="text" class="form-control" disabled name="EmailEdit"
                                                       id="Emailshow">
                                            </div>
                                            <div class="form-group">
                                                <label for="Mobile">تلگرام :</label>
                                                <input type="text" class="form-control" disabled name="TelegramEdit"
                                                       id="Telegramshow">
                                            </div>
                                            <div class="form-group">
                                                <label for="Mobile">واتس اپ :</label>
                                                <input type="text" class="form-control" disabled name="whatsAppEdit"
                                                       id="whatsAppshow">
                                            </div>
                                            <div class="form-group">
                                                <p><code>نوع مخاطب</code></p>
                                                <select id="Typeshow" class="form-control selectpicker" disabled
                                                        name="TypeEdit">
                                                    <option value="1">مشتری</option>
                                                    <option value="2">فروشنده</option>
                                                    <option value="3">مخاطب</option>
                                                    <option value="4">مشتری و فروشنده</option>
                                                </select>
                                            </div>

                                        </div>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                foreach ($Contact->result() as $user) {
                    echo '
                        <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 col-12">
                            <figure class="user-card">
                                <figcaption>
                                    <a href="#" id="test" class="edit-card" data-toggle="modal" data-target="#editContact" data-action="editContact" data-id="' . $user->contact_Id . '" >
                                        <i class="icon-mode_edit"></i>
                                    </a>
                                    <h5>' . $user->contact_firstName . ' ' . $user->contact_lastName . '</h5>
                                    <ul class="list-group">
                                        <li class="list-group-item justify-content-start">  <i class="icon-phone-call"></i> <p><a href="tel:' . $user->contact_Tell . '">' . $user->contact_Tell . '</a> </p><p>' . $user->contact_Mobile . '</p>  </li>
                                        <li class="list-group-item justify-content-start"> شرکت : ' . $user->contact_companyName . '</li>
                                        <li class="list-group-item justify-content-start">ایمیل : ' . $user->contact_Email . '</li>
                                        <li class="list-group-item justify-content-start"> 
                                            <a href="#" id="test" data-action="deleteContact" data-id="' . $user->contact_Id . '" >
                                                <i class="icon-delete"></i>
                                            </a>
                                            <a href="#" id="test" data-toggle="modal" data-target="#showContact" data-action="ShowContact" data-id="' . $user->contact_Id . '" >
                                            <i class="icon-eye color_green"></i>
                                            </a>
                                        </li>
                                        </li>
                                    </ul>
                                </figcaption>
                            </figure>
                        </div>
                        ';
                }
                ?>
            </div>
            <!-- Row end -->

        </div>
        <!-- Main container end -->

    </div>
    <!-- Page content end -->

</div>
<!-- Page wrapper end -->
<script src="<?= base_url('Assets/') ?>js/jquery.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/bootstrap.bundle.min.js"></script>
<script src="<?= base_url('Assets/') ?>js/moment.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/slimscroll.min.js"></script>
<script src="<?= base_url('Assets/') ?>vendor/slimscroll/custom-scrollbar.js"></script>
<!-- Main JS -->
<script src="<?= base_url('Assets/') ?>js/main.js"></script>
<script src="<?= base_url('Assets/') ?>send/Contact/index.js"></script>
</body>
</html>