<?php

class Storeroom_Model extends CI_Model
{
    public $tbl_storeroom, $tbl_category, $tbl_unit, $tbl_product, $tbl_importation, $tbl_exportation;

    public function __construct()
    {
        parent::__construct();
        $this->tbl_storeroom = "storeroom";
        $this->tbl_category = "category";
        $this->tbl_unit = "unit";
        $this->tbl_product = "product";
        $this->tbl_importation = "importation";
        $this->tbl_exportation = "exportation";
    }

// بررسی جدول انبار برای اینکه نام انبار تکراری وجود نداشته باشد
    public function Check_Exist_StoreroomName($Title)
    {
        $retrieve = $this->db->get_where($this->tbl_storeroom, array('storeroom_Title' => $Title));
        $count = $retrieve->num_rows();
        if ($count > 0) return true;
        else return false;
    }

// بررسی جدول انبار برای اینکه شماره انبار تکراری وجود نداشته باشد
    public function Check_Exist_StoreroomNumber($Number)
    {
        $retrieve = $this->db->get_where($this->tbl_storeroom, array('storeroom_Number' => $Number));
        $count = $retrieve->num_rows();
        if ($count > 0) return true;
        else return false;
    }

// ساخت انبار
    public function Create_Storeroom($Fields)
    {
        $retrieve = $this->db->insert($this->tbl_storeroom, $Fields);
        return $retrieve;
    }

// ویرایش انبار
    public function Edit_Storeroom($Fields, $Id)
    {
        $this->db->where('storeroom_Id', $Id);
        $retrieve = $this->db->update($this->tbl_storeroom, $Fields);
        return $retrieve;
    }

// واکشی جدول انبار بدون شرط
    public function Get_AllStoreroom()
    {
        $this->db->order_by('storeroom_Id', 'DESC');
        $retrieve = $this->db->get($this->tbl_storeroom);
        return $retrieve;
    }

// واکشی جدول انبار به صورت محدود
    public function Get_AllStoreroom_Limit($Limit)
    {
        $this->db->order_by('storeroom_Id', 'DESC');
        $this->db->limit($Limit);
        return $this->db->get($this->tbl_storeroom)->result();
    }

// واکشی ردیفی از جدول انبار با شرط برابر بودن storeroom_Id
    public function Get_Storeroom_ByID($Id)
    {
        $this->db->where('storeroom_Id', $Id);
        return $this->db->get($this->tbl_storeroom)->row();
    }

// واکشی ردیفی از جدول انبار با شرط برابر بودن storeroom_Id
    public function Get_Storeroom_ByNumber($Number)
    {
        $this->db->where('storeroom_Number', $Number);
        return $this->db->get($this->tbl_storeroom)->row();
    }

// واکشی ردیفی از جدول دسته با شرط برابر بودن category_Title
    public function Check_Exist_categoryTitle($Title, $Id)
    {
        $this->db->where(array('category_Title' => $Title, 'category_storeroomID' => $Id));
        return $this->db->get($this->tbl_category)->row();
    }

// ساخت دسته
    public function Create_Category($Fields)
    {
        $retrieve = $this->db->insert($this->tbl_category, $Fields);
        return $retrieve;
    }

// حذف دسته
    public function Delete_Category($Id)
    {
        $retrieve = $this->db->delete($this->tbl_category, array('category_Id' => $Id));
        return $retrieve;
    }


// واکشی ردیف هایی از جدول دسته با شرط برابر بودن category_storeroomID
    public function Get_AllCategory_ByStoreroomID($Id)
    {
        $this->db->order_by('category_Id', 'DESC');
        $this->db->where('category_storeroomID', $Id);
        return $this->db->get($this->tbl_category);
    }

// واکشی ردیفی از جدول دسته با شرط برابر بودن category_Id
    public function Get_Category_ByID($Id)
    {
        $this->db->where('category_Id', $Id);
        return $this->db->get($this->tbl_category)->row();
    }

// ویرایش دسته
    public function Edit_Category($Fields, $Id)
    {
        $this->db->where('category_Id', $Id);
        $retrieve = $this->db->update($this->tbl_category, $Fields);
        return $retrieve;
    }

// واکشی ردیفی از جدول واحد با شرط برابر بودن unit_Title
    public function Check_Exist_unitTitle($Title, $Id)
    {
        $this->db->where(array('unit_Title' => $Title, 'unit_storeroomID' => $Id));
        return $this->db->get($this->tbl_unit)->row();
    }

// ساخت واحد
    public function Create_Unit($Fields)
    {
        $retrieve = $this->db->insert($this->tbl_unit, $Fields);
        return $retrieve;
    }

// حذف واحد
    public function Delete_unit($Id)
    {
        $retrieve = $this->db->delete($this->tbl_unit, array('unit_Id' => $Id));
        return $retrieve;
    }

// واکشی ردیف هایی از جدول دسته با شرط برابر بودن category_storeroomID
    public function Get_AllUnit_ByStoreroomID($Id)
    {
        $this->db->where('unit_storeroomID', $Id);
        return $this->db->get($this->tbl_unit);
    }

// واکشی ردیفی از جدول دسته با شرط برابر بودن category_Id
    public function Get_Unit_ByID($Id)
    {
        $this->db->where('unit_Id', $Id);
        return $this->db->get($this->tbl_unit)->row();
    }

// ویرایش دسته
    public function Edit_Unit($Fields, $Id)
    {
        $this->db->where('unit_Id', $Id);
        $retrieve = $this->db->update($this->tbl_unit, $Fields);
        return $retrieve;
    }

// واکشی ردیفی از جدول محصول با شرط برابر بودن product_Code
    public function Check_Exist_ProductCode($Code, $Id)
    {
        $this->db->where(array('product_Code' => $Code, 'product_storeroomID' => $Id));
        return $this->db->get($this->tbl_product)->row();
    }

// ساخت محصول
    public function Create_Product($Fields)
    {
        $retrieve = $this->db->insert($this->tbl_product, $Fields);
        return $retrieve;
    }

    public function Get_AllProduct($Id)
    {
        $this->db->from('product');
        $this->db->where(array('product_storeroomID' => $Id));
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        $this->db->order_by('product.product_createDateTime', 'DESC');
        return $this->db->get();
    }

// واکشی ردیفی از جدول محصول با شرط برابر بودن product_Id
    public function Get_product_ByID($Id)
    {
        $this->db->where('product_Id', $Id);
        return $this->db->get($this->tbl_product)->row();
    }

// ویرایش دسته
    public function Edit_Product($Fields, $Id)
    {
        $this->db->where('product_Id', $Id);
        $retrieve = $this->db->update($this->tbl_product, $Fields);
        return $retrieve;
    }

// واکشی ردیفی از جدول محصول با شرط برابر بودن product_Code
    public function Get_product_ByCode($Code, $Id)
    {
        $this->db->from('product');
        $this->db->where(array('product_Code' => $Code, 'product_storeroomID' => $Id));
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        return $this->db->get()->row();
    }

// ایجاد حواله ورود
    public function Create_Importation($Fields)
    {
        $retrieve = $this->db->insert($this->tbl_importation, $Fields);
        return $retrieve;
    }

// واکشی ردیفی از جدول importation با شرط برابر بودن importation_storeroomId
    public function Get_importation_ByStoreroomId($Id)
    {
        $this->db->where(array('importation_storeroomId' => $Id));
        $this->db->join('product', 'product.product_Id = importation.importation_productId');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        $this->db->join('user', 'user.user_Id = importation.importation_Receiver');
        $this->db->join('contact', 'contact.contact_Id = importation.importation_Sender');
        $this->db->order_by('importation_Id', 'DESC');
        return $this->db->get('importation');
    }

// واکشی ردیفی از جدول importation با شرط برابر بودن importation_Id
    public function Check_Exist_ImportationId($Id)
    {
        $this->db->where(array('importation_Id' => $Id));
        return $this->db->get($this->tbl_importation)->row();
    }

// واکشی ردیفی از جدول importation با شرط برابر بودن exportation_storeroomId
    public function Get_exportation_ByStoreroomId($Id)
    {
        $this->db->from('exportation');
        $this->db->where(array('exportation_storeroomId' => $Id));
        $this->db->join('product', 'product.product_Id = exportation.exportation_productId');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        $this->db->join('user', 'user.user_Id = exportation.exportation_Sender');
        $this->db->join('contact', 'contact.contact_Id = exportation.exportation_Receiver');

        return $this->db->get();
    }

// واکشی ردیفی از جدول exportation با شرط برابر بودن exportation_Id
    public function Check_Exist_ExportationId($Id)
    {
        $this->db->where(array('exportation_Id' => $Id));
        return $this->db->get($this->tbl_exportation)->row();
    }
}
