<?php

class Header_Model extends CI_Model
{
    public $tbl_event;

    public function __construct()
    {
        parent::__construct();
        $this->tbl_event = "event";
    }

    function count_AllEvent()
    {
        return $this->db->count_all($this->tbl_event);
    }

    function count_AllEvent_Today()
    {
        $this->db->where('event_Date', jdate('Y/n/j'));
        return $this->db->count_all_results($this->tbl_event);
    }

    function count_StoreUser()
    {
        return $this->db->count_all($this->tbl_user);
    }

    function count_Product()
    {
        return $this->db->count_all($this->tbl_product);
    }

    function count_Contact()
    {
        $this->db->where('contact_Type', '3');
        return $this->db->count_all_results($this->tbl_contact);
    }

    function count_Buyer()
    {
        $contact_type = array('1', '4');
        $this->db->where_in('contact_Type', $contact_type);
        return $this->db->count_all_results($this->tbl_contact);
    }

    function count_Seller()
    {
        $contact_type = array('2', '4');
        $this->db->where_in('contact_Type', $contact_type);
        return $this->db->count_all_results($this->tbl_contact);
    }

// واکشی همه محصولات
    function get_AllProduct()
    {
        $this->db->select('product_Price, product_Amount');
        return $this->db->get($this->tbl_product)->result();
    }

// واکشی همه محصولات بر حسب StoreroomID
    function get_AllProduct_StoreroomID($Id)
    {
        $this->db->select('product_Price,product_Amount');
        $this->db->where('product_storeroomID', $Id);
        return $this->db->get($this->tbl_product)->result();
    }

// واکشی محصولات به صورت محدود
    function get_AllProduct_Limit($limit)
    {
        $this->db->limit($limit);
        $this->db->order_by('product_Id','DESC');
        $this->db->join('storeroom', 'storeroom.storeroom_Id = product.product_storeroomID');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        return $this->db->get($this->tbl_product)->result();
    }

// واکشی تعداد محصولات بر حسب product_storeroomID
    function get_Product_Count_StoreroomID($Id)
    {
        $this->db->where('product_storeroomID', $Id);
        return $this->db->count_all_results($this->tbl_product);
    }

    // واکشی تعداد ورودی ها بر حسب تاریخ
    function get_AllImportation_Count_Date($date)
    {
        $this->db->where('importation_Date', $date);
        return $this->db->count_all_results($this->tbl_importation);
    }

    // واکشی تعداد ورودی ها بر حسب importation_storeroomId
    function get_Importation_Count_StoreroomID($Id)
    {
        $this->db->where('importation_storeroomId', $Id);
        return $this->db->count_all_results($this->tbl_importation);
    }

    // واکشی تعداد خروجی ها بر حسب تاریخ
    function get_AllExportation_Count_Date($date)
    {
        $this->db->where('exportation_Date', $date);
        return $this->db->count_all_results($this->tbl_exportation);
    }

    // واکشی تعداد خروجی ها بر حسب exportation_storeroomId
    function get_Exportation_Count_StoreroomID($Id)
    {
        $this->db->where('exportation_storeroomId', $Id);
        return $this->db->count_all_results($this->tbl_exportation);
    }

}
