<?php

class Counter_Model extends CI_Model
{
    public $tbl_storeroom, $tbl_category, $tbl_unit, $tbl_product, $tbl_importation, $tbl_exportation, $tbl_user, $tbl_contact, $tbl_event;

    public function __construct()
    {
        parent::__construct();
        $this->tbl_storeroom = "storeroom";
        $this->tbl_category = "category";
        $this->tbl_unit = "unit";
        $this->tbl_product = "product";
        $this->tbl_importation = "importation";
        $this->tbl_exportation = "exportation";
        $this->tbl_user = "user";
        $this->tbl_contact = "contact";
        $this->tbl_event = "event";
    }

    function count_Storeroom()
    {
        return $this->db->count_all($this->tbl_storeroom);
    }

    function count_StoreUser()
    {
        return $this->db->count_all($this->tbl_user);
    }

    function count_Product()
    {
        return $this->db->count_all($this->tbl_product);
    }

    function count_Contact()
    {
        $this->db->where('contact_Type', '3');
        return $this->db->count_all_results($this->tbl_contact);
    }

    function count_Buyer()
    {
        $contact_type = array('1', '4');
        $this->db->where_in('contact_Type', $contact_type);
        return $this->db->count_all_results($this->tbl_contact);
    }

    function count_Seller()
    {
        $contact_type = array('2', '4');
        $this->db->where_in('contact_Type', $contact_type);
        return $this->db->count_all_results($this->tbl_contact);
    }

// واکشی همه محصولات
    function get_AllProduct()
    {
        $this->db->select('product_Price, product_Amount');
        return $this->db->get($this->tbl_product)->result();
    }

// واکشی همه محصولات بر حسب StoreroomID
    function get_AllProduct_StoreroomID($Id)
    {
        $this->db->select('product_Price,product_Amount');
        $this->db->where('product_storeroomID', $Id);
        return $this->db->get($this->tbl_product)->result();
    }

// واکشی محصولات به صورت محدود
    function get_AllProduct_Limit($limit)
    {
        $this->db->limit($limit);
        $this->db->order_by('product_Id', 'DESC');
        $this->db->join('storeroom', 'storeroom.storeroom_Id = product.product_storeroomID');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        return $this->db->get($this->tbl_product)->result();
    }

// واکشی تعداد محصولات بر حسب product_storeroomID
    function get_Product_Count_StoreroomID($Id)
    {
        $this->db->where('product_storeroomID', $Id);
        return $this->db->count_all_results($this->tbl_product);
    }

// واکشی تعداد دسته بر حسب category_storeroomID
    function get_Category_Count_StoreroomID($Id)
    {
        $this->db->where('category_storeroomID', $Id);
        return $this->db->count_all_results($this->tbl_category);
    }

// واکشی تعداد واحد بر حسب unit_storeroomID
    function get_Category_Unit_StoreroomID($Id)
    {
        $this->db->where('unit_storeroomID', $Id);
        return $this->db->count_all_results($this->tbl_unit);
    }

    // واکشی تعداد ورودی ها بر حسب تاریخ
    function get_AllImportation_Count_Date($date)
    {
        $this->db->where('importation_Date', $date);
        return $this->db->count_all_results($this->tbl_importation);
    }

    // واکشی تعداد ورودی ها بر حسب importation_storeroomId
    function get_Importation_Count_StoreroomID($Id)
    {
        $this->db->where('importation_storeroomId', $Id);
        return $this->db->count_all_results($this->tbl_importation);
    }

    // واکشی تعداد خروجی ها بر حسب تاریخ
    function get_AllExportation_Count_Date($date)
    {
        $this->db->where('exportation_Date', $date);
        return $this->db->count_all_results($this->tbl_exportation);
    }

    // واکشی تعداد خروجی ها بر حسب exportation_storeroomId
    function get_Exportation_Count_StoreroomID($Id)
    {
        $this->db->where('exportation_storeroomId', $Id);
        return $this->db->count_all_results($this->tbl_exportation);
    }

// واکشی همه اعلان ها
    function get_AllEvent()
    {
        $this->db->join('user', 'user.user_Id = event.event_Agent');
        $this->db->order_by('event.event_Id', 'DESC');
        return $this->db->get($this->tbl_event)->result();
    }

    public function Get_AllProduct_Report()
    {
        $this->db->from('product');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        $this->db->order_by('product.product_createDateTime', 'DESC');
        return $this->db->get();
    }

    public function Get_importation_Report()
    {
        $this->db->join('product', 'product.product_Id = importation.importation_productId');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        $this->db->join('user', 'user.user_Id = importation.importation_Receiver');
        $this->db->join('contact', 'contact.contact_Id = importation.importation_Sender');
        $this->db->order_by('importation_Id', 'DESC');
        return $this->db->get('importation');
    }

    public function Get_exportation_Report()
    {
        $this->db->from('exportation');
        $this->db->join('product', 'product.product_Id = exportation.exportation_productId');
        $this->db->join('category', 'category.category_Id = product.product_categoryID');
        $this->db->join('unit', 'unit.unit_Id = product.product_unitID');
        $this->db->join('user', 'user.user_Id = exportation.exportation_Sender');
        $this->db->join('contact', 'contact.contact_Id = exportation.exportation_Receiver');
        return $this->db->get();
    }

}
