<?php

class Contact_Model extends CI_Model
{
    public $tbl_contact;

    public function __construct()
    {
        parent::__construct();
        $this->tbl_contact = "contact";
    }

    // ویرایش اطلاعات مخاطب
    public function Edit_Contact($Id, $Fields)
    {
        $this->db->where('contact_Id', $Id);
        $retrieve = $this->db->update($this->tbl_contact, $Fields);
        return $retrieve;
    }

// واکشی جدول مخاطب بدون شرط
    public function Get_AllContact()
    {
        $this->db->order_by('contact_Id', 'DESC');
        $retrieve = $this->db->get($this->tbl_contact);
        return $retrieve;
    }

// واکشی جدول مخاطب با شرط فروشنده بودن
    public function Get_AllSellerContact()
    {
        $contact_type = array('2', '4');
        $this->db->where_in('contact_Type', $contact_type);
        $this->db->order_by('contact_Id', 'DESC');
        $retrieve = $this->db->get($this->tbl_contact);
        return $retrieve;
    }

// واکشی جدول مخاطب با شرط خریدار بودن
    public function Get_AllBuyerContact()
    {
        $contact_type = array('1', '4');
        $this->db->where_in('contact_Type', $contact_type);
        $this->db->order_by('contact_Id', 'DESC');
        $retrieve = $this->db->get($this->tbl_contact);
        return $retrieve;
    }

// ایجاد مخاطب
    public function Create_Contact($Fields)
    {
        $retrieve = $this->db->insert($this->tbl_contact, $Fields);
        return $retrieve;

    }

// واکشی ردیفی از جدول مخاطب با شرط برابر بودن contact_Id
    public function Get_Contact_ByID($contactId)
    {
        $this->db->where(array('contact_Id' => $contactId));
        return $this->db->get($this->tbl_contact)->row();
    }

    // حذف مخاطب
    public function Delete_Contact($contactId)
    {
        $this->db->where('contact_Id', $contactId);
        $retrieve = $this->db->delete($this->tbl_contact);
        return $retrieve;
    }
}
