<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Storeroom extends MY_Controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model('Storeroom_Model');
        $this->load->model('Contact_Model');
        $this->load->model('Counter_Model');
    }

    function index()
    {

        $this->db->select('*');
        $this->db->order_by("storeroom_Id", "random");
        $this->db->limit(2);
        $result = $this->db->get('storeroom')->result();
        $data['count_Product_0'] = $this->Counter_Model->get_Product_Count_StoreroomID($result['0']->storeroom_Id);
        $data['count_Importation_0'] = $this->Counter_Model->get_Importation_Count_StoreroomID($result['0']->storeroom_Id);
        $data['count_Exportation_0'] = $this->Counter_Model->get_Exportation_Count_StoreroomID($result['0']->storeroom_Id);
        $data['StoreroomName_0'] = $result['0']->storeroom_Title;
        $data['StoreroomName_1'] = $result['1']->storeroom_Title;
        // محاسبه ارزش رقمی و ریالی انبار 0
        $product = $this->Counter_Model->get_AllProduct_StoreroomID($result['0']->storeroom_Id);
        $count_0 = 0;
        foreach ($product as $element) {
            $count_0 = $count_0 + $element->product_Amount;
        }
        $data['Count_0'] = $count_0;
        //پایان محاسبه ارزش رقمی و ریالی انبار 0
        $data['count_Product_1'] = $this->Counter_Model->get_Product_Count_StoreroomID($result['1']->storeroom_Id);
        $data['count_Importation_1'] = $this->Counter_Model->get_Importation_Count_StoreroomID($result['1']->storeroom_Id);
        $data['count_Exportation_1'] = $this->Counter_Model->get_Exportation_Count_StoreroomID($result['1']->storeroom_Id);
        // محاسبه ارزش رقمی و ریالی انبار 1
        $product = $this->Counter_Model->get_AllProduct_StoreroomID($result['1']->storeroom_Id);
        $count_1 = 0;
        foreach ($product as $element) {
            $count_1 = $count_1 + $element->product_Amount;
        }
        $data['Count_1'] = $count_1;
        //پایان محاسبه ارزش رقمی و ریالی انبار 0
        $data['Products'] = $this->Counter_Model->get_AllProduct_Limit(5);
        $this->load->view('Storeroom/index', $data);
    }

    function mySR()
    {
        $StoreroomNumber = $this->uri->segment('3');
        $StoreroomAction = $this->uri->segment('4');
        $retrieve = $this->Storeroom_Model->Get_Storeroom_ByNumber($StoreroomNumber);
        if ($retrieve) {
            $array = array(
                $retrieve->storeroom_Id,
                $retrieve->storeroom_Number,
                $retrieve->storeroom_Title,
                $retrieve->storeroom_Description
            );
            $data['info'] = $array;
            $this->session->set_userdata('StoreroomID', $array[0]);
            if ($StoreroomAction == 'category') {
                $data['Category'] = $this->Storeroom_Model->Get_AllCategory_ByStoreroomID($this->session->userdata('StoreroomID'));
                $this->load->view('Storeroom/CreateCategory', $data);
            } elseif ($StoreroomAction == 'categories') {
                $data['Category'] = $this->Storeroom_Model->Get_AllCategory_ByStoreroomID($this->session->userdata('StoreroomID'));
                $this->load->view('Storeroom/ShowCategories', $data);
            } elseif ($StoreroomAction == 'unit') {
                $data['Unit'] = $this->Storeroom_Model->Get_AllUnit_ByStoreroomID($this->session->userdata('StoreroomID'));
                $this->load->view('Storeroom/CreateUnit', $data);
            } elseif ($StoreroomAction == 'units') {
                $data['Unit'] = $this->Storeroom_Model->Get_AllUnit_ByStoreroomID($this->session->userdata('StoreroomID'));
                $this->load->view('Storeroom/ShowUnits', $data);
            } elseif ($StoreroomAction == 'product') {
                $data['Unit'] = $this->Storeroom_Model->Get_AllUnit_ByStoreroomID($this->session->userdata('StoreroomID'));
                $data['Category'] = $this->Storeroom_Model->Get_AllCategory_ByStoreroomID($this->session->userdata('StoreroomID'));
                $data['Product'] = $this->Storeroom_Model->Get_AllProduct($this->session->userdata('StoreroomID'));
                $this->load->view('Storeroom/CreateProduct', $data);
            } elseif ($StoreroomAction == 'products') {
                $data['Unit'] = $this->Storeroom_Model->Get_AllUnit_ByStoreroomID($this->session->userdata('StoreroomID'));
                $data['Category'] = $this->Storeroom_Model->Get_AllCategory_ByStoreroomID($this->session->userdata('StoreroomID'));
                $data['Product'] = $this->Storeroom_Model->Get_AllProduct($this->session->userdata('StoreroomID'));
                $this->load->view('Storeroom/ShowProducts', $data);
            } elseif ($StoreroomAction == 'importation') {
                $data['Product'] = $this->Storeroom_Model->Get_AllProduct($this->session->userdata('StoreroomID'));
                $data['Seller'] = $this->Contact_Model->Get_AllSellerContact();
                $data['Importation'] = $this->Storeroom_Model->Get_importation_ByStoreroomId($this->session->userdata('StoreroomID'));
                $data['Date'] = $this->NowDate();
                $this->load->view('Storeroom/Importation', $data);
            } elseif ($StoreroomAction == 'importations') {
                $data['Product'] = $this->Storeroom_Model->Get_AllProduct($this->session->userdata('StoreroomID'));
                $data['Seller'] = $this->Contact_Model->Get_AllSellerContact();
                $data['Importation'] = $this->Storeroom_Model->Get_importation_ByStoreroomId($this->session->userdata('StoreroomID'));
                $data['Date'] = $this->NowDate();
                $this->load->view('Storeroom/ShowImportations', $data);
            } elseif ($StoreroomAction == 'exportation') {
                $data['Product'] = $this->Storeroom_Model->Get_AllProduct($this->session->userdata('StoreroomID'));
                $data['Buyer'] = $this->Contact_Model->Get_AllBuyerContact();
                $data['Exportation'] = $this->Storeroom_Model->Get_exportation_ByStoreroomId($this->session->userdata('StoreroomID'));
                $data['Date'] = $this->NowDate();
                $this->load->view('Storeroom/Exportation', $data);
            } elseif ($StoreroomAction == 'exportations') {
                $data['Product'] = $this->Storeroom_Model->Get_AllProduct($this->session->userdata('StoreroomID'));
                $data['Buyer'] = $this->Contact_Model->Get_AllBuyerContact();
                $data['Exportation'] = $this->Storeroom_Model->Get_exportation_ByStoreroomId($this->session->userdata('StoreroomID'));
                $data['Date'] = $this->NowDate();
                $this->load->view('Storeroom/ShowExportations', $data);
            } else {
                $data['count_Product'] = $this->Counter_Model->get_Product_Count_StoreroomID($this->session->userdata('StoreroomID'));
                $data['count_Category'] = $this->Counter_Model->get_Category_Count_StoreroomID($this->session->userdata('StoreroomID'));
                $data['count_Unit'] = $this->Counter_Model->get_Category_Unit_StoreroomID($this->session->userdata('StoreroomID'));
                $data['count_Importation'] = $this->Counter_Model->get_Importation_Count_StoreroomID($this->session->userdata('StoreroomID'));
                $data['count_Exportation'] = $this->Counter_Model->get_Exportation_Count_StoreroomID($this->session->userdata('StoreroomID'));

                $this->load->view('Storeroom/index2', $data);
            }
        } else {
            redirect('Custom404');
        }
    }

    function not_access()
    {
        $this->load->view('Panel/not_access');
    }

    function Create()
    {
        $data['Storeroom'] = $this->Storeroom_Model->Get_AllStoreroom_Limit(9);
        $this->load->view('Storeroom/CreateStoreroom', $data);
    }

    function Storerooms()
    {
        $data['Storeroom'] = $this->Storeroom_Model->Get_AllStoreroom();
        $this->load->view('Storeroom/ShowStorerooms', $data);
    }

    function CreateDB()
    {
        $array = array();
        $Fields = array(
            'storeroom_Number' => str_replace(',', '', $this->input->post('Number', true)),
            'storeroom_Title' => $this->input->post('Title', true),
            'storeroom_Description' => $this->input->post('Description', true),
            'storeroom_createDate' => strtotime(date('Y/m/d')),
            'storeroom_createTime' => $this->NowTime()
        );
        if (!empty($Fields['storeroom_Title']) && !empty($Fields['storeroom_Number'])) {
            $check_StoreroomNumber = $this->Storeroom_Model->Check_Exist_StoreroomNumber($Fields['storeroom_Number']);
            if ($check_StoreroomNumber) {
                array_push($array, "existNumber");
            } else {
                $retrieve = $this->Storeroom_Model->Create_Storeroom($Fields);
                if ($retrieve) {
                    array_push($array, "Created");
                } else {
                    array_push($array, "not_Created");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function EditDB()
    {
        $array = array();
        $Fields = array(
            'storeroom_Number' => str_replace(',', '', $this->input->post('Number', true)),
            'storeroom_Title' => $this->input->post('Title', true),
            'storeroom_Description' => $this->input->post('Description', true)
        );
        if (!empty($Fields['storeroom_Title']) && !empty($Fields['storeroom_Number'])) {
            if ($Fields['storeroom_Number'] != $this->session->userdata('storeroom_Number')) {
                $check_StoreroomNumber = $this->Storeroom_Model->Check_Exist_StoreroomNumber($Fields['storeroom_Number']);
                if ($check_StoreroomNumber) {
                    array_push($array, "existNumber");
                } else {
                    $retrieve = $this->Storeroom_Model->Edit_Storeroom($Fields, $this->input->post('Id', true));
                    if ($retrieve) {
                        $session_unset_array = array('storeroom_Number', 'storeroom_Title');
                        $this->session->unset_userdata($session_unset_array);
                        array_push($array, "Edited");
                    } else {
                        array_push($array, "not_Edited");
                    }
                }

            } else {
                $retrieve = $this->Storeroom_Model->Edit_Storeroom($Fields, $this->input->post('Id', true));
                if ($retrieve) {
                    $session_unset_array = array('storeroom_Number', 'storeroom_Title');
                    $this->session->unset_userdata($session_unset_array);
                    array_push($array, "Edited");
                } else {
                    array_push($array, "not_Edited");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function Get_Storeroom_ByID()
    {
        $storeroom_Id = $this->input->post('id', true);
        $retrieve = $this->Storeroom_Model->Get_Storeroom_ByID($storeroom_Id);
        $array = array(
            $retrieve->storeroom_Id,
            $retrieve->storeroom_Number,
            $retrieve->storeroom_Title,
            $retrieve->storeroom_Description
        );
        $storeroom_Session = array(
            'storeroom_Number' => $retrieve->storeroom_Number,
            'storeroom_Title' => $retrieve->storeroom_Title
        );
        $this->session->set_userdata($storeroom_Session);
        echo json_encode($array);
    }

    function CreateCategoryDB()
    {
        $array = array();
        $Fields = array(
            'category_Title' => $this->input->post('Title', true),
            'category_storeroomID' => $this->session->userdata('StoreroomID')
        );
        if (!empty($Fields['category_Title'])) {
            $check_categoryTitle = $this->Storeroom_Model->Check_Exist_categoryTitle($Fields['category_Title'], $Fields['category_storeroomID']);
            if ($check_categoryTitle) {
                array_push($array, "existTitle");
            } else {
                $retrieve = $this->Storeroom_Model->Create_Category($Fields);
                if ($retrieve) {
                    array_push($array, "Created");
                } else {
                    array_push($array, "not_Created");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function Get_Category_ByID()
    {
        $category_Id = $this->input->post('id', true);
        $retrieve = $this->Storeroom_Model->Get_Category_ByID($category_Id);
        $array = array(
            $retrieve->category_Id,
            $retrieve->category_Title,
            $retrieve->category_storeroomID,
        );
        echo json_encode($array);
    }

    function EditCategoryDB()
    {
        $array = array();
        $Fields = array(
            'category_Title' => $this->input->post('Title', true),
        );
        if (!empty($Fields['category_Title'])) {
            $check_CategoryTitle = $this->Storeroom_Model->Check_Exist_categoryTitle($Fields['category_Title'], $this->session->userdata('StoreroomID'));
            if ($check_CategoryTitle) {
                array_push($array, "existName");
            } else {
                $retrieve = $this->Storeroom_Model->Edit_Category($Fields, $this->input->post('Id', true));
                if ($retrieve) {
                    array_push($array, "Edited");
                } else {
                    array_push($array, "not_Edited");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function CreateUnitDB()
    {
        $array = array();
        $Fields = array(
            'unit_Title' => $this->input->post('Title', true),
            'unit_storeroomID' => $this->session->userdata('StoreroomID')
        );
        if (!empty($Fields['unit_Title'])) {
            $check_unitTitle = $this->Storeroom_Model->Check_Exist_unitTitle($Fields['unit_Title'], $Fields['unit_storeroomID']);
            if ($check_unitTitle) {
                array_push($array, "existTitle");
            } else {
                $retrieve = $this->Storeroom_Model->Create_Unit($Fields);
                if ($retrieve) {
                    array_push($array, "Created");
                } else {
                    array_push($array, "not_Created");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function Get_Unit_ByID()
    {
        $unit_Id = $this->input->post('id', true);
        $retrieve = $this->Storeroom_Model->Get_Unit_ByID($unit_Id);
        $array = array(
            $retrieve->unit_Id,
            $retrieve->unit_Title,
            $retrieve->unit_storeroomID,
        );
        echo json_encode($array);
    }

    function EditUnitDB()
    {
        $array = array();
        $Fields = array(
            'unit_Title' => $this->input->post('Title', true),
        );
        if (!empty($Fields['unit_Title'])) {
            $check_UnitTitle = $this->Storeroom_Model->Check_Exist_unitTitle($Fields['unit_Title'], $this->session->userdata('StoreroomID'));
            if ($check_UnitTitle) {
                array_push($array, "existName");
            } else {
                $retrieve = $this->Storeroom_Model->Edit_Unit($Fields, $this->input->post('Id', true));
                if ($retrieve) {
                    array_push($array, "Edited");
                } else {
                    array_push($array, "not_Edited");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function CreateProductDB()
    {
        $array = array();
        $Fields = array(
            'product_Price' => str_replace(',', '', $this->input->post('Price', true)),
            'product_Code' => str_replace(',', '', $this->input->post('Code', true)),
            'product_Title' => $this->input->post('Title', true),
            'product_Description' => $this->input->post('Description', true),
            'product_unitID' => $this->input->post('Unit', true),
            'product_categoryID' => $this->input->post('Category', true),
            'product_storeroomID' => $this->session->userdata('StoreroomID'),
            'product_createDateTime' => strtotime(date('Y/m/d'))
        );
        if (!empty($Fields['product_Title']) && !empty($Fields['product_Code']) && !empty($Fields['product_unitID']) && !empty($Fields['product_categoryID'])) {
            $check_ProductCode = $this->Storeroom_Model->Check_Exist_ProductCode($Fields['product_Code'], $Fields['product_storeroomID']);
            if ($check_ProductCode) {
                array_push($array, "existCode");
            } else {
                $retrieve = $this->Storeroom_Model->Create_Product($Fields);
                if ($retrieve) {
                    array_push($array, "Created");
                } else {
                    array_push($array, "not_Created");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function Get_Product_ByID()
    {
        $product_Id = $this->input->post('id', true);
        $retrieve = $this->Storeroom_Model->Get_Product_ByID($product_Id);
        $array = array(
            $retrieve->product_Id,
            $retrieve->product_Code,
            $retrieve->product_Title,
            $retrieve->product_Description,
            $retrieve->product_unitID,
            $retrieve->product_categoryID,
            $retrieve->product_Price,
        );
        $product_SessionEdit = array(
            'product_Code' => $retrieve->product_Code
        );
        $this->session->set_userdata($product_SessionEdit);
        echo json_encode($array);
    }

    function Get_Contact_ByID()
    {
        $contact_Id = $this->input->post('id', true);
        $retrieve = $this->Contact_Model->Get_Contact_ByID($contact_Id);
        $array = array(
            $retrieve->contact_Id,
            $retrieve->contact_firstName,
            $retrieve->contact_lastName,
            $retrieve->contact_companyName,
        );
        $contact_Session = array(
            'contact_Id' => $retrieve->contact_Id
        );
        $this->session->set_userdata($contact_Session);
        echo json_encode($array);
    }

    function EditProductDB()
    {
        $array = array();
        $Fields = array(
            'product_Price' => str_replace(',', '', $this->input->post('Price', true)),
            'product_Code' => str_replace(',', '', $this->input->post('Code', true)),
            'product_Title' => $this->input->post('Title', true),
            'product_Description' => $this->input->post('Description', true),
            'product_unitID' => $this->input->post('Unit', true),
            'product_categoryID' => $this->input->post('Category', true),
        );
        if (!empty($Fields['product_Title']) && !empty($Fields['product_Code']) && !empty($Fields['product_unitID']) && !empty($Fields['product_categoryID'])) {
            if ($Fields['product_Code'] != $this->session->userdata('product_Code')) {
                $check_ProductCode = $this->Storeroom_Model->Check_Exist_ProductCode($Fields['product_Code'], $this->session->userdata('StoreroomID'));
                if ($check_ProductCode) {
                    array_push($array, "existCode");
                } else {
                    $retrieve = $this->Storeroom_Model->Edit_Product($Fields, $this->input->post('Id', true));
                    if ($retrieve) {
                        $session_unset_array = array('product_Code');
                        $this->session->unset_userdata($session_unset_array);
                        array_push($array, "Edited");
                    } else {
                        array_push($array, "not_Edited");
                    }
                }
            } else {
                $retrieve = $this->Storeroom_Model->Edit_Product($Fields, $this->input->post('Id', true));
                if ($retrieve) {
                    array_push($array, "Edited");
                } else {
                    array_push($array, "not_Edited");
                }
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function Get_Product_ByCode()
    {
        $array = array();
        $product_Code = $this->input->post('Code', true);
        if (!empty($product_Code)) {
            $retrieve = $this->Storeroom_Model->Get_product_ByCode($product_Code, $this->session->userdata('StoreroomID'));
            if ($retrieve) {
                $array = array(
                    $retrieve->product_Id,
                    $retrieve->product_Code,
                    $retrieve->product_Title,
                    $retrieve->product_Description,
                    $retrieve->unit_Title,
                    $retrieve->category_Title,
                    number_format(@$retrieve->product_Price) . '  ریال ',
                    number_format($retrieve->product_Amount),
                );
            } else {
                array_push($array, 'not_Find');
            }
        } else {
            array_push($array, 'empty');
        }
        sleep(3);
        echo json_encode($array);
    }

    function CreateImportationDB()
    {
//        $date = $this->input->post('Date', true);
//        $date = explode('/', $date);
//        $array = array();
//        strtotime(jalali_to_gregorian($date[0], $date[1], $date[2], '/'));
//
//        array_push($array, strtotime(jalali_to_gregorian($date[0], $date[1], $date[2], '/')));
//        echo json_encode($array);

        $array = array();
        $date = $this->input->post('Date');
        $date1 = array();
        $Fields = array(
            'importation_productId' => $this->input->post('Id', true),
            'importation_storeroomId' => $this->session->userdata('StoreroomID'),
            'importation_havaleCode' => $this->input->post('havaleCode', true),
            'importation_Amount' => str_replace(',', '', $this->input->post('Amount', true)),
            'importation_Sender' => $this->input->post('Sender', true),
            'importation_Receiver' => $this->user_id,
            'importation_Description' => $this->input->post('Description', true),
            'importation_Time' => $this->NowTime()
        );
        if (!empty($Fields['importation_productId'])) {
            if (!empty($Fields['importation_havaleCode']) && !empty($Fields['importation_Amount']) && !empty($Fields['importation_Sender']) && !empty($date)) {
                $date1 = explode('/', $date);
                $Fields['importation_Date'] = jalali_to_gregorian($date1[0], $date1[1], $date1[2], '/');
                $seller_Id = $this->session->userdata('contact_Id');
                $Fields['importation_Sender'] = $seller_Id;
                if (!empty($seller_Id)) {
                    $check_ProductId = $this->Storeroom_Model->Get_Product_ByID($Fields['importation_productId']);
                    if ($check_ProductId) {
                        $this->db->trans_start();
                        //وارد کردن اطلاعات حواله در جدول importation
                        $this->db->insert('importation', $Fields);
                        $FieldsEvent = array(
                            "event_Agent" => $Fields['importation_Receiver'],
                            "event_Description" => 'وارد کردن حواله به شماره ' . $Fields['importation_havaleCode'],
                            "event_Date" => $this->NowDate(),
                            "event_Time" => $this->NowTime()
                        );
                        //ویرایش مقدار موجودی کالا در جدول product
                        $this->db->where('product_Id', $Fields['importation_productId']);
                        $this->db->update('product', array('product_Amount' => $check_ProductId->product_Amount + $Fields['importation_Amount']));
                        //ثبت رخداد در جدول event
                        $this->db->insert('event', $FieldsEvent);
                        $this->db->trans_complete();
                        if ($this->db->trans_status() === true) {
                            $this->session->unset_userdata('contact_Id');
                            array_push($array, "Created");
                        } else {
                            array_push($array, "not_Created");
                        }
                    } else {
                        array_push($array, "not_Exist");
                    }
                } else {
                    array_push($array, "seller_empty");
                }

            } else {
                array_push($array, "empty");
            }
        } else {
            array_push($array, "not_Find");
        }
        sleep(3);
        echo json_encode($array);
    }

    function DeleteImportation()
    {
        $array = array();
        $Fields = array(
            'importation_Id' => $this->input->post('Id', true),
        );
        if (!empty($Fields['importation_Id'])) {
            $check_ImportationId = $this->Storeroom_Model->Check_Exist_ImportationId($Fields['importation_Id']);
            if ($check_ImportationId) {
                $product_Id = $check_ImportationId->importation_productId;
                $product_Amount = $this->Storeroom_Model->Get_product_ByID($product_Id)->product_Amount;
                if ($product_Amount < $check_ImportationId->importation_Amount) {
                    array_push($array, "not_EnoughAmount");
                } else {
                    $this->db->trans_start();
                    //حذف کردن اطلاعات حواله از جدول importation
                    $this->db->where('importation_Id', $Fields['importation_Id']);
                    $this->db->delete('importation');
                    //ویرایش مقدار موجودی کالا در جدول product
                    $this->db->set('product_Amount', 'product_Amount - ' . $check_ImportationId->importation_Amount, FALSE);
                    $this->db->where('product_Id', $check_ImportationId->importation_productId);
                    $this->db->update('product');
                    //ثبت رخداد در جدول event
                    $FieldsEvent = array(
                        "event_Agent" => $this->user_id,
                        "event_Description" => 'حذف کردن حواله به شماره ' . $check_ImportationId->importation_havaleCode,
                        "event_Date" => $this->NowDate(),
                        "event_Time" => $this->NowTime(),
                        "event_data" => serialize($check_ImportationId)
                    );
                    $this->db->insert('event', $FieldsEvent);
                    $this->db->trans_complete();
                    if ($this->db->trans_status() === true) {
                        array_push($array, "Deleted");
                    } else {
                        array_push($array, "not_Deleted");
                    }
                }

            } else {
                array_push($array, "not_Exist");
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function CreateExportationDB()
    {
        $array = array();
        $Fields = array(
            'exportation_productId' => $this->input->post('Id', true),
            'exportation_storeroomId' => $this->session->userdata('StoreroomID'),
            'exportation_havaleCode' => $this->input->post('havaleCode', true),
            'exportation_Amount' => str_replace(',', '', $this->input->post('Amount', true)),
            'exportation_Sender' => $this->user_id,
            'exportation_Receiver' => $this->input->post('Receiver', true),
            'exportation_Description' => $this->input->post('Description', true),
            'exportation_Date' => $this->input->post('Date', true),
            'exportation_Time' => $this->NowTime()
        );
        if (!empty($Fields['exportation_productId'])) {
            if (!empty($Fields['exportation_havaleCode']) && !empty($Fields['exportation_Amount']) && !empty($Fields['exportation_Receiver']) && !empty($Fields['exportation_Date'])) {
                $exportation_Date = explode('/', $Fields['exportation_Date']);
                $Fields['exportation_Date'] = jalali_to_gregorian($exportation_Date[0], $exportation_Date[1], $exportation_Date[2], '/');
                $buyer_Id = $this->session->userdata('contact_Id');
                $Fields['exportation_Receiver'] = $buyer_Id;
                if (!empty($buyer_Id)) {
                    $check_ProductId = $this->Storeroom_Model->Get_Product_ByID($Fields['exportation_productId']);
                    if ($check_ProductId) {
                        if ($check_ProductId->product_Amount >= $Fields['exportation_Amount']) {
                            $this->db->trans_start();
                            //وارد کردن اطلاعات حواله در جدول exportation
                            $this->db->insert('exportation', $Fields);
                            $FieldsEvent = array(
                                "event_Agent" => $Fields['exportation_Sender'],
                                "event_Description" => 'خارج کردن حواله به شماره ' . $Fields['exportation_havaleCode'],
                                "event_Date" => $this->NowDate(),
                                "event_Time" => $this->NowTime()
                            );
                            //ویرایش مقدار موجودی کالا در جدول product
                            $this->db->where('product_Id', $Fields['exportation_productId']);
                            $this->db->update('product', array('product_Amount' => $check_ProductId->product_Amount - $Fields['exportation_Amount']));
                            //ثبت رخداد در جدول event
                            $this->db->insert('event', $FieldsEvent);
                            $this->db->trans_complete();
                            if ($this->db->trans_status() === true) {
                                $this->session->unset_userdata('contact_Id');
                                array_push($array, "Created");
                            } else {
                                array_push($array, "not_Created");
                            }
                        } else {
                            array_push($array, "not_Enough");
                        }
                    } else {
                        array_push($array, "not_Exist");
                    }
                } else {
                    array_push($array, "buyer_empty");
                }
            } else {
                array_push($array, "empty");
            }
        } else {
            array_push($array, "not_Find");
        }
        sleep(3);
        echo json_encode($array);
    }

    function DeleteExportation()
    {
        $array = array();
        $Fields = array(
            'exportation_Id' => $this->input->post('Id', true),
        );
        if (!empty($Fields['exportation_Id'])) {
            $check_ExportationId = $this->Storeroom_Model->Check_Exist_ExportationId($Fields['exportation_Id']);
            if ($check_ExportationId) {
                $this->db->trans_start();
                //حذف کردن اطلاعات حواله از جدول exportation
                $this->db->where('exportation_Id', $Fields['exportation_Id']);
                $this->db->delete('exportation');
                //ویرایش مقدار موجودی کالا در جدول product
                $this->db->set('product_Amount', 'product_Amount + ' . $check_ExportationId->exportation_Amount, FALSE);
                $this->db->where('product_Id', $check_ExportationId->exportation_productId);
                $this->db->update('product');
                //ثبت رخداد در جدول event
                $FieldsEvent = array(
                    "event_Agent" => $this->user_id,
                    "event_Description" => 'حذف کردن حواله به شماره ' . $check_ExportationId->exportation_havaleCode,
                    "event_Date" => $this->NowDate(),
                    "event_Time" => $this->NowTime(),
                    "event_data" => serialize($check_ExportationId)
                );
                $this->db->insert('event', $FieldsEvent);
                $this->db->trans_complete();
                if ($this->db->trans_status() === true) {
                    array_push($array, "Deleted");
                } else {
                    array_push($array, "not_Deleted");
                }
            } else {
                array_push($array, "not_Exist");
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function DeleteProduct()
    {
        $array = array();
        $product_Id = $this->input->post('Id', true);
        if (!empty($product_Id)) {
            $check_ProductId = $this->Storeroom_Model->Get_product_ByID($product_Id);
            if ($check_ProductId) {
                $this->db->trans_start();
                //حذف محصول از جدول product
                $this->db->where('product_Id', $product_Id);
                $this->db->delete('product');
                //ثبت رخداد در جدول event
                $FieldsEvent = array(
                    "event_Agent" => $this->user_id,
                    "event_Description" => 'حذف محصول با شناسه ' . $check_ProductId->product_Code,
                    "event_Date" => $this->NowDate(),
                    "event_Time" => $this->NowTime(),
                    "event_data" => serialize($check_ProductId)
                );
                $this->db->insert('event', $FieldsEvent);
                $this->db->trans_complete();
                if ($this->db->trans_status() === true) {
                    array_push($array, "Deleted");
                } else {
                    array_push($array, "not_Deleted");
                }
            } else {
                array_push($array, "not_Exist");
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function DeleteStoreroom()
    {
        $array = array();
        $storeroom_Id = $this->input->post('Id', true);
        if (!empty($storeroom_Id)) {
            $check_StoreroomId = $this->Storeroom_Model->Get_Storeroom_ByID($storeroom_Id);
            if ($check_StoreroomId) {
                $this->db->trans_start();
                //حذف انبار از جدول storeroom
                $this->db->where('storeroom_Id', $storeroom_Id);
                $this->db->delete('storeroom');
                //ثبت رخداد در جدول event
                $FieldsEvent = array(
                    "event_Agent" => $this->user_id,
                    "event_Description" => 'حذف انبار با نام ' . $check_StoreroomId->storeroom_Title,
                    "event_Date" => $this->NowDate(),
                    "event_Time" => $this->NowTime(),
                    "event_data" => serialize($check_StoreroomId)
                );
                $this->db->insert('event', $FieldsEvent);
                $this->db->trans_complete();
                if ($this->db->trans_status() === true) {
                    array_push($array, "Deleted");
                } else {
                    array_push($array, "not_Deleted");
                }
            } else {
                array_push($array, "not_Exist");
            }
        } else {
            array_push($array, "empty");
        }
        sleep(3);
        echo json_encode($array);
    }

    function deleteCategory()
    {
        $id = $this->input->post('id', true);
        $retrieve = $this->Storeroom_Model->Delete_Category($id);
        if ($retrieve) echo "Deleted";
        else echo "not_Deleted";
    }

    function deleteUnit()
    {
        $id = $this->input->post('id', true);
        $retrieve = $this->Storeroom_Model->Delete_Unit($id);
        if ($retrieve) echo "Deleted";
        else echo "not_Deleted";
    }

}
